using System;
using System.Xml;

using BC.Core.ASTs;

namespace BC.Core.Annotations
{
	public class NodeAnnotationElement
	{
		protected XmlElement e;

		public NodeAnnotationElement (XmlElement e)
		{
			this.e = e;
		}

		public string this [string x]
		{
			get
			{
				if (e.Attributes[x] != null)
					return e.Attributes["x"].Value;
				else
					return null;
			}
			set
			{
				if (e.Attributes[x] != null)
					if (value == null)
						e.Attributes.Remove(e.Attributes[x]);
					else
						e.Attributes[x].Value = value;
				else
				{
					e.Attributes.Append(e.OwnerDocument.CreateAttribute(x));

					e.Attributes[x].Value = value;
				}
			}
		}
	}
}
