using System;
using System.Xml;

using BC.Core.ASTs;

namespace BC.Core.Annotations
{
	public class NodeAnnotation
	{
		protected AbstractNode node;

		public NodeAnnotation (AbstractNode node)
		{
			Node = node;
		}

		protected AbstractNode Node
		{
			get
			{
				return node;
			}
			set
			{
				node = value;
			}
		}

		public NodeAnnotationElement this [string name]
		{
			get
			{
				if (Node.Annotation == null)
					Node.Annotation = new XmlElement[0];

				foreach (XmlElement e in Node.Annotation)
					if (e.Name == name)
						return new NodeAnnotationElement(e);

				Node.Annotation = (XmlElement[])Global.AppendToArray(Node.Annotation, new XmlDocument().CreateElement(name));

				return new NodeAnnotationElement(Node.Annotation[Node.Annotation.Length - 1]);
			}
		}
	}
}
