/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/Core/ASTs/Create.cs,v $
 * $Revision: 1.1 $
 * $Date: 2002/12/05 03:07:54 $
 */

using System;
using System.Collections;

namespace BC.Core.ASTs
{
	public class Create
	{
		// Initializers

		public static AbstractInitializer Initializer (AbstractExpression e)
		{
			Initializer i = new Initializer();

			i.Expression = e;

			return i;
		}

		public static AbstractInitializer Initializer (params AbstractInitializer[] x)
		{
			InitializerList l = new InitializerList();

			l.Initializer = x;

			return l;
		}

		// Declarations

		public static Declaration Declaration (string name, AbstractType type, AbstractInitializer i)
		{
			Declaration d = new Declaration();

			d.Name = name;
			d.Type = type;
			d.Value = i;

			return d;
		}

		public static Declaration Declaration (string name, AbstractType type)
		{
			return Declaration(name, type, null);
		}

		public static Declaration Declaration (AbstractType type)
		{
			return Declaration(null, type);
		}

		public static Declaration[] Declarations (params Declaration[] x)
		{
			return x;
		}

		// Methods

		public static MethodDefinition Method (string name, AbstractType returnType, Declaration[] arguments, CompoundStatement body)
		{
			MethodDefinition d = new MethodDefinition();

			d.Name = name;
			d.Type = FunctionType(returnType, arguments);
			d.Body = body;

			return d;
		}

		// Elements

		public static Elements Elements (params AbstractElement[] x)
		{
			Elements e = new Elements();

			e.Element = x;

			return e;
		}

		// Types

		public static AbstractType FunctionType (AbstractType returnType, params Declaration[] arguments)
		{
			FunctionType t = new FunctionType();

			t.Base = returnType;
			t.Argument = arguments;

			return t;
		}

		public static AbstractType ArrayType (AbstractType baseType, AbstractExpression[] dimensions)
		{
			ArrayType t = new ArrayType();

			t.Base = baseType;
			t.Dimension = dimensions;

			return t;
		}

		public static IndirectType IndirectType (AbstractType baseType)
		{
			IndirectType t = new IndirectType();

			t.Base = baseType;

			return t;
		}

		public static RealType RealType (int precision)
		{
			RealType t = new RealType();

			t.Precision = precision;

			return t;
		}

		public static IntegerType IntegerType (int precision, bool signed)
		{
			IntegerType t = new IntegerType();

			t.Precision = precision;
			t.Signed = signed;

			return t;
		}

		public static IntegerType IntegerType (int precision)
		{
			return IntegerType(precision, true);
		}

		// Statements

		public static AbstractStatement Statement (Declaration d)
		{
			DeclarationStatement s = new DeclarationStatement();

			s.Declaration = d;

			return s;
		}

		public static AbstractStatement Statement (AbstractExpression e)
		{
			ExpressionStatement s = new ExpressionStatement();

			s.Expression = e;

			return s;
		}

		public static CompoundStatement Statement (params AbstractStatement[] x)
		{
			CompoundStatement s = new CompoundStatement();

			s.Statement = x;

			return s;
		}

		public static AbstractStatement[] Statements (params AbstractStatement[] x)
		{
			return x;
		}

		public static AbstractStatement[] Statements (ICollection c)
		{
			AbstractStatement[] s = new AbstractStatement[c.Count];

			c.CopyTo(s, 0);

			return s;
		}

		public static AbstractStatement ForStatement (AbstractExpression init, AbstractExpression condition, AbstractExpression update, CompoundStatement body)
		{
			ForStatement s = new ForStatement();

			s.Init = init;
			s.Expression = condition;
			s.Update = update;

			s.Statement = body;

			return s;
		}

		public static AbstractStatement ReturnStatement (AbstractExpression e)
		{
			ReturnStatement s = new ReturnStatement();

			s.Expression = e;

			return s;
		}

		public static AbstractStatement ReturnStatement ()
		{
			return ReturnStatement(null);
		}

		// Expressions

		public static AbstractExpression Expression (Operator o, AbstractExpression l, AbstractExpression r)
		{
			BinaryExpression e = new BinaryExpression();

			e.Operator = o;
			e.LeftOperand = l;
			e.RightOperand = r;

			return e;
		}

		public static AbstractExpression Expression (Operator o, AbstractExpression x)
		{
			UnaryExpression e = new UnaryExpression();

			e.Operator = o;
			e.Operand = x;

			return e;
		}

		public static AbstractExpression Expression (string name)
		{
			NamedExpression n = new NamedExpression();

			n.Name = name;

			return n;
		}

		public static AbstractExpression Expression (int i)
		{
			IntegerConstant c = new IntegerConstant();

			c.Value = i.ToString();

			return c;
		}

		public static AbstractExpression Expression (double d)
		{
			RealConstant c = new RealConstant();

			c.Value = d;

			return c;
		}

		public static AbstractExpression[] Expressions (AbstractExpression[] x)
		{
			return x;
		}
	}
}