/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/C/CUI.cs,v $
 * $Revision: 1.3 $
 * $Date: 2002/12/10 20:06:24 $
 */

using System;
using System.Resources;

using BC.Core;

namespace BC.C
{
	public class CUI: UI
	{
		public new enum Code
		{
			c99_6_7_1_2,
			c99_6_7_2_1_4,
			c99_6_7_2_2,
			c99_6_7_3,
			//c99_6_7_5_3_3, obsolete, incorporated in the grammar
			c99_6_9_1_6_s1,
			bc_001,
			bc_002,
			bc_003,
		}

		private ResourceManager rm = new ResourceManager("BC.C.UI", typeof(CUI).Assembly);
		
		private GetStringDelegate OldGetString;

		private string PrivateGetString (object o)
		{
			string r = rm.GetString(o.ToString());

			if (r == null)
				r = OldGetString(o);

			return r;
		}

		public CUI (GetStringDelegate d)
		{
			OldGetString = d;

			GetString = new GetStringDelegate(PrivateGetString);
		}
	}
}
