using System;
using System.Collections;
using System.Diagnostics;

using BC.Core.Passes;
using BC.Core.ASTs;

using Omega;

namespace BC.C
{
	// Use objects of this class to store info as you traverse the AST
	public class DAState
	{
		// Add whatever fields you want here...
	}

	// DependenceAnalysis is implemented as a code Walker.
	// Walker implements the Visitor design pattern.
	// The DependenceAnalysis walker is invoked from line 58 in BCC.cs
	public class DependenceAnalysis: Walker
	{
		// VisitMethodDefinition is invoked for each function
		// (and method!) definition.
 		protected override void VisitMethodDefinition (MethodDefinition d, object o)
 		{
 			Console.WriteLine();
 			Console.WriteLine("Function: {0}", d.Name);

			// A new DAState object that will be used during
			// the AST traversal.
			DAState x = new DAState();

			// Calling VisitMethodDefinition in the base
			// class result in the child AST's of this node to
			// be traversed.
			base.VisitMethodDefinition(d, x);
 		}

		protected override void VisitForStatement (ForStatement s, object o)
		{
			// x points the DAState object in which will we
			// collect information.
			DAState x = (DAState)o;

			// Calling VisitForDefinition in the base
			// class result in the child AST's of this node to
			// be traversed.
			base.VisitForStatement(s, o);
		}

		protected override void VisitArrayExpression (ArrayExpression e, object o)
		{
			// x points the DAState object in which will we
			// collect information.
			DAState x = (DAState)o;

			// Calling VisitArrayDefinition in the base
			// class result in the child AST's of this node to
			// be traversed.
			base.VisitArrayExpression(e, o);
		}
	}
}
