/*
 * Bernoulli Compiler
 * Copyright (c) Cornell University
 * Department of Computer Science
 * 
 * Kamen Yotov (kamen@yotov.org)
 * 
 * $Source: C:/CVS/kyotov/kyotov/Research/BC/BCC/BCC.cs,v $
 * $Revision: 1.15 $
 * $Date: 2003/02/23 18:16:40 $
 */

#define X

using System;
using System.IO;

using BC.Core.Exceptions;
using BC.Core.Passes;
using BC.Core.ASTs;

using System.Collections;
using System.Resources;

namespace BC.C
{
	class BCC
	{
		static void Main(string[] a)
		{
			ArrayList l = new ArrayList();

			foreach (string s1 in a)
				foreach (string s2 in Directory.GetFiles(Directory.GetCurrentDirectory(), s1))
					l.Add(s2);

			CParser p = new CParser(false);

			foreach (string s3 in l)
			{
				try
				{
					DateTime t = DateTime.Now;

					BC.Core.Global.GetString = new CUI(BC.Core.Global.GetString).GetString;

					UIDSetter s = new UIDSetter();
					ArrayFixup p1 = new ArrayFixup();
					DependenceAnalysis p2 = new DependenceAnalysis();
					ASTWriter w = new ASTWriter(s3 + ".xml");
					CRenderer r = new CRenderer(s3 + ".bcc.c");

					Elements e = null;

					p.Execute(ref e, s3);
					s.Execute(ref e);
					p1.Execute(ref e);
					p2.Execute(ref e);
					w.Execute(ref e);
					r.Execute(ref e);

					Console.WriteLine("  Time: {0}", DateTime.Now - t);
				}
#if X
				catch (BCException e)
				{
					Console.WriteLine();
					Console.WriteLine(e);
				}
#else
				catch (ImpossibleException)
				{
					throw;
				}
#endif
			}
		}
	}
}