/* Vladimir Kotlyar  March 1996
 * 
 * Memory interface routines for Alpha library
 *
 */

#ifndef _a_memory_h
#define _a_memory_h

struct _arena_object {
    struct _arena_object *next;
};

struct _arena_info {
    struct _arena_object *objs;
};

typedef struct _arena_object arena_object;
typedef struct _arena_info arena_info;

void *a_arena_calloc(arena_info *, size_t nelem, size_t elsize);
arena_info *a_arena_make();
void a_arena_free(arena_info *);

#define a_alloc0(a,T)		((T*)a_arena_calloc(a,1,sizeof(T)))
#define a_nalloc0(a,T,n)	((T*)a_arena_calloc(a,n,sizeof(T)))

#endif
