#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "alpha_io2.h"

#include "alpha_memory.h"

void *a_arena_calloc(arena_info *a, size_t nelem, size_t elsize)
{
    arena_object *p = calloc(nelem*elsize+sizeof(arena_object),1);
    p->next = a->objs;
    a->objs = p;
    return (void*)(p+1);
}

arena_info *a_arena_make()
{
    return (arena_info*)calloc(1,sizeof(arena_info));
}

void a_arena_free(arena_info *a)
{
    arena_object *p = a->objs;
    while (p) {
	arena_object *t = p->next;
	free(p);
	p = t;
    }
    free(a);
}
