/* Vladimir Kotlyar Sepember 1995
 *
 * Matrix manipulation
 *
 * NOTE: To be consistent with various descriptions of matrix
 * algorithms, all indices start from ONE
 *
 */


#ifndef _a_matrix_private_h
#define _a_matrix_private_h


#include <stdio.h>
#include <assert.h>

#ifndef _a_range_h
#include "alpha_range.h"
#endif

#ifndef _a_alloc_h
#include "alpha_memory.h"
#endif

/**********************************************************************/
struct xa_vec_s {
  int		n;
  int		*a;
};

typedef struct xa_vec_s xa_vec_t;
typedef struct xa_vec_s *xa_vec;

#define xa_size_vec(v)		((v)->n)
#define xa_elts_vec(v)		((v)->a)
#define xa_elt_vec(v,i)		((v)->a[xa_check_range((i),xa_size_vec(v)),((i)-1)])

/**********************************************************************/

/*
 * A matrix is a collection of COLUMN vectors.  This makes sense, since
 * many algorithms we implement are column-oriented
 */

struct xa_mx_s {
  int	  	rows;
  int		cols;
  xa_vec	*a;   
};

typedef struct xa_mx_s xa_mx_t;
typedef struct xa_mx_s *xa_mx;


#define xa_rows_mx(m)		((m)->rows)
#define xa_cols_mx(m)		((m)->cols)

#define xa_col_mx(m,j)		((m)->a[xa_check_range((j),xa_cols_mx(m)),((j)-1)])
#define xa_elt_mx(m,i,j)	(xa_elt_vec(xa_col_mx((m),(j)),(i)))

#define xa_col_data_mx(m)	((m)->a)

#define XA_FOR_COLS_MX(A,col,j) \
{  xa_vec_t *col; int j;\
   for (j=1; j <= xa_cols_mx(A); j++) {\
      col = xa_col_mx((A),j);

#define XA_END_COLS_MX \
   }}

xa_vec_t*	xa_alloc_vector (arena_info *arena, int n);
xa_mx_t*	xa_alloc_matrix (arena_info *arena, int m, int n);
					
#endif
