structure LSPP = LambdaSimplePPrint
structure CPP = CPSPPrint

(* Use to parse a file in input language for HW5 into source languge for HW5 *)
fun load_lambda_simple f 
  = let
      val _ = Compiler.PPTable.install_pp 
	      ["LambdaSimpleAst", "expr"] LSPP.ppExpr
      val _ = Compiler.PPTable.install_pp 
	      ["CPSAst", "exp"] CPP.ppExp
      val _ = Compiler.PPTable.install_pp 
	      ["CPSAst", "stm"] CPP.ppStm
      val e = LambdaSimpleParser.parse f
    in
      LambdaSimpleAst.alpha_vary e
    end

(* Use to run program in source language for HW5 *)
fun run_lambda_simple e 
  = LambdaSimpleInterpretation.interpret
    (LambdaSimpleAst.alpha_vary e)

(* Use to parse a file in input langauge for HW5 into source language for HW5
   and run program in source language for HW5 *)
fun test_lambda_simple f 
  = (LSPP.ppE(run_lambda_simple(load_lambda_simple f)); 
     print "\n")

(* Use to translate program in source language for HW5 into cps langauge for HW5 *)
fun cps_translate e
  = CPSTranslate.cps_translate
    (LambdaSimpleAst.alpha_vary e)

(* Use to run program in cps language for HW5 *)
fun run_cps s
  = (CPSEvaluation.evaluate s
     handle (exn as CPSEvaluation.CpsFailure s) => (print s;
						    print "\n";
						    raise exn))

(* Use to parse a file in input langauge for HW5 into source language for HW5
   and translate program in source language for HW5 into cps language for HW5
   and run program in cps language for HW5 *)
fun test_cps_translate f 
  = (CPP.ppE(run_cps(cps_translate(load_lambda_simple f))); 
     print "\n")

