signature LAMBDA_SIMPLE_AST = sig

  type var = string * int

  val eqvar : var -> var -> bool
  val newvar : string -> var

  datatype primop = 
    Plus                   
  | Times
  | Minus

  datatype expr =
    Var of var
  | Num of int
  | IsZero of expr
  | Lambda of var * expr
  | App of expr * expr
  | Op of primop * expr * expr
  | True
  | False
  | If of expr * expr * expr

  val alpha_vary : expr -> expr
  val alpha_equiv : expr -> expr -> bool

end
