structure CPSAst : CPS_AST =
  struct

    type var = LambdaSimpleAst.var
    val eqvar = LambdaSimpleAst.eqvar
    val newvar = LambdaSimpleAst.newvar

    datatype exp = 
      Var of var 
    | Lam of var * stm
    | Halt 
    | Tuple of var list
    | Op of primop * var * var
    | Num of int
    | Index of var * int
    and stm = 
      App of var * var 
    | Ifz of var * stm * stm
    | Let of var * exp * stm 
    and primop = Plus | Times | Minus
  end