structure LambdaSimplePPrint : LAMBDA_SIMPLE_PPRINT = struct
  
  val ppAlpha = ref false

  local 
    open LambdaSimpleAst Compiler.PrettyPrint
  in
    fun ppVar pps (s, i) =
      let val str = s ^ (if !ppAlpha then Int.toString i else "") in
	add_string pps str
      end

    fun ppNum pps i = 
      if i >= 0 then add_string pps (Int.toString i)
      else add_string pps ("-"^(Int.toString (~1 * i)))

    fun ppPrimop pps p = 
      let val pp = add_string pps in
      case p of 
	Plus =>  pp "+"
      | Times => pp "*"
      | Minus => pp "-"
      end

    fun ppExpr pps e = 
      let val pp = add_string pps in
      case e of
	Var v => ppVar pps v
      | Lambda (v, e)
      => (begin_block pps INCONSISTENT 1;
	  pp "(fn ";
	  begin_block pps INCONSISTENT 2;
	  pp "(";
	  ppVar pps v;
	  pp ")";
	  add_break pps (1,2);
	  ppExpr pps e;
	  end_block pps;
          pp ")";
	  end_block pps
	  )
      | App(e1, e2)
      => (begin_block pps INCONSISTENT 0;
	  pp "(";
	  begin_block pps INCONSISTENT 0;
	  ppExpr pps e1;
	  add_break pps (1,2);
	  ppExpr pps e2;
	  end_block pps;
	  pp ")";
	  end_block pps
	  )  
      | Num i 
      => ppNum pps i
      | IsZero(e)
      => (begin_block pps INCONSISTENT 0;
	  pp "(iszero? ";
	  begin_block pps INCONSISTENT 0;
	  ppExpr pps e;
	  end_block pps;
	  pp ")";
	  end_block pps
	  )
      | Op (p, e1, e2)
      => (begin_block pps INCONSISTENT 0;
	  pp "(";
	  begin_block pps INCONSISTENT 0;
	  ppPrimop pps p;
	  add_break pps (1,2);
	  ppExpr pps e1;
	  add_break pps (1,2);
	  ppExpr pps e2;
	  end_block pps;
	  pp ")";
	  end_block pps
	  )
      | If (b, e1, e2)
      => (begin_block pps INCONSISTENT 0;
	  pp "(if ";
	  begin_block pps INCONSISTENT 0;
	  ppExpr pps b;
	  add_break pps (1,2);
	  ppExpr pps e1;
	  add_break pps (1,2);
	  ppExpr pps e2;
	  end_block pps;
	  pp ")";
	  end_block pps
	  )
      | True
      => pp "#t"
      | False
      => pp "#f"
      end

    fun ppE e = 
      let val s = pp_to_string 75 ppExpr e in print s end
  end
end


