structure LambdaSimpleParser : LAMBDA_SIMPLE_PARSER = struct

  structure LambdaSimpleLrVals 
    = LambdaSimpleLrValsFun(structure Token = LrParser.Token)
  structure LambdaSimpleLex 
    = LambdaSimpleLexFun(structure Tokens = LambdaSimpleLrVals.Tokens)
  structure LambdaSimpleParser 
    = Join(structure LrParser = LrParser
	   structure ParserData = LambdaSimpleLrVals.ParserData
	   structure Lex = LambdaSimpleLex)
    
  exception Error
  
  val invoke = fn lexstream =>
    let val error = fn (s, i, _) =>
      (print ("ERROR (Line " ^ (Int.toString i) ^ "): " ^ s ^ "\n");
       raise Error)
    in
      LambdaSimpleParser.parse(0, lexstream, error, ())
    end
  
  fun parse filename = 
    let
      val _ = LambdaSimpleLex.UserDeclarations.pos := 1
      val h = TextIO.openIn filename
      val lexer = LambdaSimpleParser.makeLexer (fn _ => TextIO.input h)
      val (result, _) = invoke lexer
    in
      result
    end
end
