structure LambdaSimpleAst : LAMBDA_SIMPLE_AST = struct
  type var = string * int

  fun eqvar (s1, i1) (s2, i2) = i1 = i2
  val vctr = ref 0
  fun newvar s = let 
    val v = !vctr 
    val _ = vctr := v+1
  in
    (s, v)
  end


  datatype primop = Plus | Times | Minus
  datatype expr = Var of var
                | Num of int
                | IsZero of expr
                | Lambda of var * expr
                | App of expr * expr
                | Op of primop * expr * expr
                | True
                | False
                | If of expr * expr * expr

  exception Bad
  fun alpha_vary expr =
    let
      fun add ctxt str i = (str, i)::ctxt
      fun lookup x [] = raise Bad
	| lookup x ((str, i)::rest) = if x = str 
					then (str, i) 
					else lookup x rest
      fun bindnew (str,_) ctxt = let
				   val (_, i) = newvar str
				 in
				   ((str, i), add ctxt str i)
				 end
      
      val rec alpha 
	= fn ctxt
	   => (fn Var (str, i) 
	        => (Var(lookup str ctxt) handle Bad => Var(str, i))
		| Num i => Num i
	        | IsZero(e) => IsZero(alpha ctxt e)
	        | Lambda (v, e)
	        => let
		     val (v', ctxt') = bindnew v ctxt
		   in
		     Lambda(v', alpha ctxt' e)
		   end
		| App (e1, e2)
		=> App (alpha ctxt e1, alpha ctxt e2)
		| Op (p, e1, e2)
		=> Op (p, alpha ctxt e1, alpha ctxt e2)
                | True => True
                | False => False
                | If (b,e1,e2) 
                => If (alpha ctxt b, alpha ctxt e1, alpha ctxt e2))
    in
      alpha [] expr
    end
  fun alpha_equiv expr =
    let
      fun add ctxt i j = (i, j)::ctxt
      fun lookup x [] = raise Bad
	| lookup x ((i, j)::rest) = if x = i 
				      then j 
				      else lookup x rest
      fun bindnew (_,i) (_,j) ctxt = add ctxt i j

      fun alpha ctxt e1 e2
	= (case (e1, e2)
	     of (Var (_, i), Var (_,j))
              => ((lookup i ctxt = j) handle Bad => false)
	      | (Num i, Num j) => i = j
	      | (IsZero(e1), IsZero(e2)) => alpha ctxt e1 e2
	      | (Lambda (v1,e1), Lambda (v2,e2))
	      => let
		   val ctxt' = bindnew v1 v2 ctxt
		 in
		   alpha ctxt' e1 e2
		 end
	      | (App (e11,e12), App(e21,e22))
	      => (alpha ctxt e11 e21) andalso
                 (alpha ctxt e12 e22)
	      | (Op (p1,e11,e12), Op (p2,e21,e22))
	      => (p1 = p2) andalso
                 (alpha ctxt e11 e21) andalso
                 (alpha ctxt e12 e22)
	      | (True, True) => true
	      | (False, False) => true
	      | (If (b1,e11,e12), If (b2,e21,e22))
	      => (alpha ctxt b1 b2) andalso
                 (alpha ctxt e11 e21) andalso
                 (alpha ctxt e12 e22) 
              | _ => false)
    in
      alpha [] expr
    end

end
