structure CPSPPrint : CPS_PPRINT = struct

  val ppAlpha = ref false

  local 
    open CPSAst Compiler.PrettyPrint
  in
    fun ppVar pps (s, i) =
      let val str = s ^ (if !ppAlpha then Int.toString i else "") in
	add_string pps str
      end

    fun ppNum pps i = 
      if i >= 0 then add_string pps (Int.toString i)
      else add_string pps ("-"^(Int.toString (~1 * i)))

    fun ppList printer pps style list =
      let 
	val pp = add_string pps
	fun ppListH [] = ()
	  | ppListH [x] = printer pps x
	  | ppListH (x::rest) = 
	  (printer pps x;
	   pp ",";
	   add_break pps (1, 0);
	   ppListH rest)
      in
	(begin_block pps style 0;
	 ppListH list;
	 end_block pps)
      end

    fun ppPrimop pps p = 
      let val pp = add_string pps in
      case p of 
	Plus =>  pp "+"
      | Times => pp "*"
      | Minus => pp "-"
      end

    fun ppExp pps e = 
      let val pp = add_string pps in
      case e of
	Var v => ppVar pps v
      | Lam (v, s)
      => (begin_block pps INCONSISTENT 1;
	  pp "\\";
	  ppVar pps v;
	  pp ". ";
	  ppStm pps s;
	  end_block pps
	  )
      | Halt
      => pp "halt"
      | Tuple vl
      => (begin_block pps INCONSISTENT 0;
	  pp "<";
	  ppList ppVar pps INCONSISTENT vl;
	  pp ">";
	  end_block pps
	  )
      | Index (v,n)
      => (ppVar pps v;
	  pp "[";
	  ppNum pps n;
	  pp "]")
      | Op (p, v1, v2)
      => (ppVar pps v1;
	  pp " ";
	  ppPrimop pps p;
	  pp " ";
	  ppVar pps v2)
      | Num i 
      => ppNum pps i
      end
    and ppStm pps s = 
      let val pp = add_string pps in
      case s of
	App (v1,v2)
      => (ppVar pps v1;
	  pp " ";
	  ppVar pps v2)
      | Ifz (v,s1,s2)
      => (begin_block pps INCONSISTENT 0;
	  pp "ifz ";
	  ppVar pps v;
	  add_break pps (1,2);
	  pp "[";
	  ppStm pps s1;
	  pp "]";
	  add_break pps (1,2);
	  pp "[";
	  ppStm pps s2;
	  pp "]";
	  end_block pps
	  )
      | Let (v,e,s)
      => (begin_block pps INCONSISTENT 0;
	  pp "let ";
	  ppVar pps v;
	  pp " = ";
	  ppExp pps e;
	  pp " in";
	  add_newline pps;
	  ppStm pps s;
	  end_block pps
	  )
      end
	 
    fun ppE e = 
      let val s = pp_to_string 75 ppExp e in print s end
    fun ppS e = 
      let val s = pp_to_string 75 ppStm e in print s end
  end
end
