signature CPS_AST = 
  sig
    type var = LambdaSimpleAst.var
    val eqvar : var -> var -> bool
    val newvar : string -> var
      
    datatype exp = 
      Var of var 
    | Lam of var * stm
    | Halt 
    | Tuple of var list
    | Index of var * int
    | Op of primop * var * var
    | Num of int
    and stm = 
      App of var * var 
    | Ifz of var * stm * stm
    | Let of var * exp * stm 
    and primop = Plus | Times | Minus
  end