functor PPrint(ImpAst : IMPAST) : PPRINT = struct
  
  structure ImpAst = ImpAst

  fun pprintLoc l = print l

  local 
    open ImpAst
  in
    fun pprintAexp a = pprintAexp'(0, a)
   and pprintBexp b = pprintBexp'(0, b)
   and pprintCom c = pprintCom'(0, c)
   and NSpace 0 = ()
      | NSpace n = (print " "; NSpace(n-1))


    and pprintAexp'(n, (N m)) = print(Int.toString m)
      | pprintAexp'(n, (Loc l)) = pprintLoc l
      | pprintAexp'(n, (Plus(a1, a2))) = (print "("; pprintAexp'(n, a1); print " + "; pprintAexp'(n, a2); print ")")
      | pprintAexp'(n, (Minus(a1, a2))) = (print "("; pprintAexp'(n, a1); print " - "; pprintAexp'(n, a2); print ")")
      | pprintAexp'(n, (Times(a1, a2))) = (print "("; pprintAexp'(n, a1); print " * "; pprintAexp'(n, a2); print ")")
      | pprintAexp'(n, (ComAexp(Assign(l, a)))) = (print "{ "; pprintCom'(0, Assign(l, a)); print " }")
      | pprintAexp'(n, (ComAexp(c))) = (print "{\n"; pprintCom'(n+2, c); print "\n"; NSpace n; print "}")

    and	pprintBexp'(n, (True)) = print "true"
      | pprintBexp'(n, (False)) = print "false"
      | pprintBexp'(n, (Equals(a1, a2))) = (print "("; pprintAexp'(n, a1); print " = "; pprintAexp'(n, a2); print ")")
      | pprintBexp'(n, (LessEq(a1, a2))) = (print "("; pprintAexp'(n, a1); print " <= "; pprintAexp'(n, a2); print ")")
      | pprintBexp'(n, (Not(b))) = (print "not "; pprintBexp'(n, b))
      | pprintBexp'(n, (And(b1, b2))) = (print "("; pprintBexp'(n, b1); print " and "; pprintBexp'(n, b2); print ")")
      | pprintBexp'(n, (Or(b1, b2))) = (print "("; pprintBexp'(n, b1); print " or "; pprintBexp'(n, b2); print ")")

   and pprintCom' (n, Skip) = (NSpace n; print "skip")
      | pprintCom' (n, Assign(l, a)) = (NSpace n; pprintLoc l; print " := "; pprintAexp a)
      | pprintCom' (n, Seq(c1, c2)) = (pprintCom'(n, c1); print ";\n"; pprintCom'(n, c2))
      | pprintCom' (n, Cond(b, c1, c2)) = (NSpace n; print "if "; pprintBexp b; print " then {\n";
					   pprintCom'(n+2, c1); print "\n"; NSpace n; print "} else {\n";
					   pprintCom'(n+2, c2); print "\n"; NSpace n; print "}")
      | pprintCom' (n, While(b, c)) = (NSpace n; print "while "; pprintBexp b; print " {\n";
				       pprintCom'(n+2, c); print "\n"; NSpace n; print "}")
      | pprintCom' (n, AexpCom(a)) = (NSpace n; pprintAexp a)

  end

end


