structure Parser : PARSER = struct

  structure Imp = Interpretation(ImpAst)
  structure PP = PPrint(ImpAst)
    
  structure ImpLrVals = ImpLrValsFun(structure Token = LrParser.Token)
  structure ImpLex = ImpLexFun(structure Tokens = ImpLrVals.Tokens)
  structure ImpParser = Join(structure LrParser = LrParser
			     structure ParserData = ImpLrVals.ParserData
			     structure Lex = ImpLex)
    
  exception Error
  
  val invoke = fn lexstream =>
    let val error = fn (s, i, _) =>
      (print ("ERROR (Line " ^ (Int.toString i) ^ "): " ^ s ^ "\n");
       raise Error)
    in
      ImpParser.parse(0, lexstream, error, ())
    end
  
  fun parse filename = 
    let
      val _ = ImpLex.UserDeclarations.pos := 1
      val h = TextIO.openIn filename
      val lexer = ImpParser.makeLexer (fn _ => TextIO.input h)
      val (result, _) = invoke lexer
    in
      result
    end
			   
end
