functor Interpretation(ImpAst : IMPAST) : INTERPRETATION = struct

    structure ImpAst = ImpAst

    type state = ImpAst.loc -> int
    type config = ImpAst.Com * state

    val initialState : state = fn _ => 0
	
    fun updateState (s, l, n) =
	(fn l' => if l' = l then n else (s l'))
	
    fun lookupState (s : state, l) = (s l)

    exception Unimplemented

    exception BadCommandAexp
	
    local
	open ImpAst
    in
	
	fun interpretAexp (N(n), s) = n
	  | interpretAexp (Loc(l), s) = lookupState(s, l)
	  | interpretAexp (Plus(a1, a2), s) = 
	    let
		val v1 = interpretAexp(a1, s)
		val v2 = interpretAexp(a2, s)
	    in
		v1 + v2
	    end
	  | interpretAexp (Minus(a1, a2), s) =
	    let
		val v1 = interpretAexp(a1, s)
		val v2 = interpretAexp(a2, s)
	    in
		v1 - v2
	    end
	  | interpretAexp (Times(a1, a2), s) =
	    let
		val v1 = interpretAexp(a1, s)
		val v2 = interpretAexp(a2, s)
	    in
		v1 * v2
	    end
          | interpretAexp (ComAexp(c), s) = raise Unimplemented
	
	fun interpretBexp (True, s) = true
	  | interpretBexp (False, s) = false
	  | interpretBexp (Equals(a1, a2), s) = 
	    let
		val v1 = interpretAexp(a1, s)
		val v2 = interpretAexp(a2, s)
	    in
		v1 = v2
	    end
	  | interpretBexp (LessEq(a1, a2), s) =
	    let
		val v1 = interpretAexp(a1, s)
		val v2 = interpretAexp(a2, s)
	    in
		v1 <= v2
	    end
	  | interpretBexp (Not(b), s) =
	    let
		val b = interpretBexp(b, s)
	    in
		not b
	    end
	  | interpretBexp (And(b1, b2), s) =
	    let
		val b1 = interpretBexp(b1, s)
		val b2 = interpretBexp(b2, s)
	    in
		b1 andalso b2
	    end
	  | interpretBexp (Or(b1, b2), s) =
	    let
		val b1 = interpretBexp(b1, s)
		val b2 = interpretBexp(b2, s)
	    in
		b1 orelse b2
	    end
	
	fun interpret (Skip, s) = s
	  | interpret (Assign (l, aexp), s) = 
	    let 
		val v = interpretAexp(aexp, s)
	    in
		updateState(s, l, v)
	    end
	  | interpret (Seq(c1, c2), s) = 
	    let 
		val s' = interpret(c1, s)
	    in
		interpret(c2, s')
	    end
	  | interpret (Cond(bexp, c1, c2), s) =
	    let
		val b = interpretBexp(bexp, s)
	    in
		if b then interpret(c1, s) else interpret(c2, s)
	    end
	  | interpret (While(bexp, c), s) =
	    let
		val b = interpretBexp(bexp, s)
	    in
		if b then 
		    let
			val s'' = interpret(c, s)
		    in
			interpret(While(bexp, c), s'')
		    end 
		else
		    s
	    end
	  | interpret (AexpCom(a), s) = raise Unimplemented

	(* CS611: replace the dummy function below with the   *)
        (* extensions to the IMP interpretter to handle       *)
        (* commands as arithmetic expressions and vice versa. *)
	fun interpretSE _ = raise Unimplemented

  end
end


