signature IMPAST = sig

  type loc = string

  datatype Aexp = 
    N of int 
  | Loc of loc
  | Plus of Aexp * Aexp
  | Minus of Aexp * Aexp
  | Times of Aexp * Aexp
  | ComAexp of Com

  and Bexp =
    True
  | False
  | Equals of Aexp * Aexp
  | LessEq of Aexp * Aexp
  | Not of Bexp
  | And of Bexp * Bexp
  | Or of Bexp * Bexp

  and Com =
    Skip
  | Assign of loc * Aexp
  | Seq of Com * Com
  | Cond of Bexp * Com * Com
  | While of Bexp * Com
  | AexpCom of Aexp

end
