open Ast

(* Reduce the expression to the normalized form described as follows:
 * all bound variables are distinct and all applications are of an
 * expression to a variable or to a constant. *)
let rec normalize e = 
  (*
  let _ = print_string "normalizing:\n" in
  let _ = Pprint.pp_expr e in
  let _ = print_newline() in
  *)
  match e with
    Var v -> Var v
  | Num n -> Num n
  | True -> True
  | False -> False
  | Loc l -> Loc l
  | Op(op, e1, e2) -> Op(op, normalize e1, normalize e2)
  | Zerop expr -> Zerop (normalize expr)
  | If (e0,e1,e2) -> If (normalize e0, normalize e1, normalize e2)
  | Left expr -> Left (normalize expr)
  | Right expr -> Right (normalize expr)
  | Pair(e1, e2) -> Pair (normalize e1, normalize e2)
  | Fn (v, body) -> Fn (v, normalize body)
  | App (e1, Var v) -> App (normalize e1, Var v)
  | App (e1, Num n) -> App (normalize e1, Num n)
  | App (e1, True) -> App (normalize e1, True)
  | App (e1, False) -> App (normalize e1, False)
  | App (e1, e2) -> let y = newvar "y_" in
		    Let ((y, normalize e2), App (normalize e1, Var y))
  | Let ((v,expr), body) -> Let ((v,normalize expr), (normalize body))
  | Ref expr -> Ref (normalize expr)
  | Deref expr -> Deref (normalize expr)
  | Assign (e1, e2) -> Assign (normalize e1, normalize e2)
  | Seq (e1, e2) -> Seq (normalize e1, normalize e2)

(* Translate a call-by-need expression to call-by-value.
 * CS611: implement this*)
let to_call_by_value e =
  let force e = (match e with Fn(z, e) -> e | _ -> App(e, Num 777)) in
  let delay e = let z = newvar "_" in Fn(z,e) in

  let rec cbv e =
    match e with
(* ------------------------------------------------------------ *)
    | Var x -> raise (Failure "611: unimplemented")
    | Fn(v, body) -> raise (Failure "611: unimplemented")
    | App (e0, e1) -> raise (Failure "611: unimplemented")
    | Let ((v,e),body) -> raise (Failure "611: unimplemented")
    | Ref e -> raise (Failure "611: unimplemented")
    | Deref e -> raise (Failure "611: unimplemented")
    | Assign (e0,e1) -> raise (Failure "611: unimplemented")
    | Seq (e0,e1) -> raise (Failure "611: unimplemented")
(* ------------------------------------------------------------ *)
    | Op (op,e0,e1) -> delay (Op(op, force (cbv e0), force (cbv e1)))
    | Zerop expr -> delay (Zerop (force (cbv expr)))
    | If (e0,e1,e2) -> delay (If(force (cbv e0), force (cbv e1), force (cbv e2)))
    | Left e -> Left (force (cbv e))
    | Right e -> Right (force (cbv e))
    | Pair (e0,e1) -> delay (Pair(cbv e0, cbv e1))
    | Num n -> delay (Num n)
    | True  -> delay (True)
    | False -> delay (False)
    | Loc l -> delay (Loc l)
  in
    force (cbv e)

(* After translation, all values look like <v,s>, where v is a value and
 * s is a store. *)

(* We implement the store as a pair <n,f>, where n is the next location
 * to allocate and f is a lookup function.  This is not an efficient
 * implementation, but works. *)

(* empty = <0, error> *)
let empty = Pair((Num 0), let e = newvar "error" in Fn(e, ast_error))

(* malloc s = left s *)
let malloc s = Left(s)

(* lookup s l = (right s) l *)
let lookup s l = App(Right s, l)

(* update s l v = <(left s) + 1, fn u -> if (u = l) then v else (lookup s u)> *)
let update s l v = let u = newvar "u_" in
                   Pair(Op(Plus,Left(s),Num 1),
		        Fn(u, If(Op(Eq, (Var u), l), v, lookup s (Var u))))

(* Remove refs by threading the store through the computation. *)
let remove_refs e =
  let rec rr e s =
    let ast_let v e e' = App(Fn(v, e'), e) in

    match e with
      Var _ | Num _ | Loc _ | True | False -> Pair(e, s)
    | Let ((v,e),body) -> rr (ast_let v e body) s
    | Op (op, e0, e1) -> let p = newvar "p_" in
			 let q = newvar "q_" in
			 ast_let p (rr e0 s)
				 (ast_let q (rr e1 (Right (Var p)))
					  (Pair(Op(op, Left (Var p),
					               Left (Var q)),
					        Right (Var q))))
    | Zerop expr -> let p = newvar "p_" in
		    ast_let p (rr expr s)
			    (Pair (Zerop (Left (Var p)), Right (Var p)))
    | If (e0,e1,e2) -> let p = newvar "p_" in
                       ast_let p (rr e0 s)
			       (If (Left (Var p),
				    (rr e1 (Right (Var p))),
				    (rr e2 (Right (Var p)))))
    | Left e -> let p = newvar "p_" in
		ast_let p (rr e s)
		        (Pair(Left (Left (Var p)), Right (Var p)))
    | Right e -> let p = newvar "p_" in
		 ast_let p (rr e s)
		        (Pair(Right (Left (Var p)), Right (Var p)))
    | Pair (e0,e1) -> let p = newvar "p_" in
                      let q = newvar "q_" in
                      ast_let p (rr e0 s)
			      (ast_let q (rr e1 (Right (Var p)))
			               (Pair(Pair (Left (Var p), Left (Var q)),
				             Right (Var q))))
(* ------------------------------------------------------------ *)
    | App (e0, e1) -> raise (Failure "611: unimplemented")
    | Fn(v, body) ->  raise (Failure "611: unimplemented")
    | Ref e -> raise (Failure "611: unimplemented--need to remove")
    | Deref e ->  raise (Failure "611: unimplemented--need to remove")
    | Assign (e0,e1) -> raise (Failure "611: unimplemented--need to remove")
    | Seq (e0,e1) -> raise (Failure "611: unimplemented--need to remove")
(* ------------------------------------------------------------ *)
  in
    Left(rr e empty)
