let rec pprintLoc l = print_string l

open Ast
open Format

let pp_alpha = ref true

let pp = print_string

let ppV = fun (s,i) -> if !pp_alpha then pp (s ^ (string_of_int i))
				    else pp s

let ppO = function
    Plus -> pp "+"
  | Minus -> pp "-"
  | Times -> pp "*"
  | Eq -> pp "="
  | Lt -> pp "<"

let rec ppE = function
    Var v -> ppV v
  | Num n -> print_int n
  | Op(op, e1, e2) -> (open_box 0;
		       pp "(";
		       ppO op;
		       pp " ";
		       ppE e1;
		       print_break 1 3;
		       ppE e2;
		       pp ")";
		       close_box())
  | Zerop e -> (pp "(zero? ";
		ppE e;
		pp ")")
  | True -> pp "#t"
  | False -> pp "#f"
  | If (e0,e1,e2) -> (open_box 0;
                      pp "(if ";
		      ppE e0;
		      print_break 1 4;
		      ppE e1;
		      print_break 1 4;
		      ppE e2;
		      pp ")";
		      close_box())
  | Left e -> (pp "(left ";
               ppE e;
	       pp ")")
  | Right e -> (pp "(right ";
                ppE e;
		pp ")")
  | Pair (e1,e2) -> (pp "<";
                     ppE e1;
		     pp ", ";
		     ppE e2;
		     pp ">")
  | Fn (v,e) -> (open_box 0;
                 pp "(fn ";
		 pp "(";
		 ppV v;
		 pp ")";
		 print_break 1 4;
		 ppE e;
		 pp ")";
                 close_box())
  | App (e1,e2) -> (open_box 0;
                    pp "(";
                    ppE e1;
		    print_break 1 1;
		    ppE e2;
		    pp ")";
		    close_box())
  | Let ((v,e),e') -> (open_box 0;
		       pp "(let ";
		       open_box 0;
		       pp "(";
		       ppVEs ((v,e)::[]);
		       pp ")";
		       close_box();
		       print_break 1 8;
		       ppE e';
		       pp ")";
		       close_box())
  | Ref e -> (pp "(ref ";
              ppE e;
	      pp ")")
  | Deref e -> (pp "(! ";
                ppE e;
		pp ")")
  | Assign (e1,e2) -> (open_box 0;
                       pp "(:= ";
		       ppE e1;
		       print_break 1 4;
		       ppE e2;
		       pp ")";
		       close_box())
  | Seq (e1,e2) -> (open_box 0;
                    pp "(seq ";
		    ppE e1;
		    print_break 1 5;
		    ppE e2;
		    pp ")";
		    close_box())
  | Loc l -> (pp "(loc ";
              print_int l;
	      pp ")")

  and ppVEs = function
    [] -> ()
  | (v,e)::[] -> (pp "("; ppV v; pp " "; ppE e; pp ")")
  | (v,e)::ves -> (pp "("; ppV v; pp " "; ppE e; pp ")"; print_break 1 2; ppVEs ves)

let rec pp_expr e = (ppE e; print_flush())
