%{
open Ast
open Translate

let rec do_and = function
		[] -> True
	      | (e::es) -> If(e, (do_and es), False)
let rec do_or = function
		[] -> False
	      | (e::es) -> If(e, True, (do_or es))
let rec do_plus = function
		[] -> Num 0
	      | e1::[] -> e1
	      | e1::es -> Op(Plus, e1, (do_plus es))
let rec do_times = function
		[] -> Num 1
	      | e1::[] -> e1
	      | e1::es -> Op(Times, e1, (do_times es))
%}

%token <int> INT
%token <string> VAR
%token PLUS MINUS TIMES ZEROP EQ NE LT GT LE GE
%token LPAREN RPAREN
%token LEFT RIGHT COMMA
%token FN LET
%token AND OR NOT TRUE FALSE IF
%token REF BANG ASSIGN SEQ
%token EOF

%type <Ast.expr> parse
%type <Ast.expr> expr
%type <Ast.var list> vs
%type <Ast.expr list> es

%start parse

%%

parse: expr EOF           { $1 }

expr : INT                { Num $1 }
     | VAR                { Var ($1, -1) }
     | TRUE               { True }
     | FALSE              { False }
     | LPAREN EQ expr expr RPAREN { Op(Eq, $3, $4) }
     | LPAREN LT expr expr RPAREN { Op(Lt, $3, $4) }
     | LPAREN PLUS expr es RPAREN { do_plus ($3::$4) }
     | LPAREN TIMES expr es RPAREN { do_times ($3::$4) }
     | LPAREN MINUS expr expr RPAREN { Op(Minus, $3, $4) }
     | LPAREN ZEROP expr RPAREN { Zerop $3 }
     | LPAREN AND expr expr es RPAREN { do_and ($3::$4::$5) }
     | LPAREN OR expr expr es RPAREN { do_or ($3::$4::$5) }
     | LPAREN LEFT expr RPAREN { Left $3 }
     | LPAREN RIGHT expr RPAREN { Right $3 }
     | LPAREN IF expr expr expr RPAREN { If($3, $4,$5) }
     | LPAREN FN LPAREN vs RPAREN expr RPAREN { ast_fn $4 $6 }
     | LPAREN expr expr es RPAREN { ast_app ($2::$3::$4) }
     | LPAREN LET LPAREN ves RPAREN expr RPAREN {
              List.fold_right (fun (v,e) body -> Let((v,e), body)) $4 $6 }
     | LT expr COMMA expr GT { Pair($2,$4) }
     | LPAREN REF expr RPAREN { Ref $3 }
     | LPAREN BANG expr RPAREN { Deref $3 }
     | LPAREN ASSIGN expr expr RPAREN { Assign($3,$4) }
     | LPAREN SEQ expr expr RPAREN { Seq($3,$4) }
     ;

vs :			{ [] }
	| VAR vs	{ ($1,-1)::$2 }
	;

es:			{ [] }
	| expr es		{ $1::$2 }
	;

ves :			{ [] }
	| LPAREN VAR expr RPAREN ves	{ (($2,-1),$3)::$5 }
	;
