let test file =
    let p s e = (print_endline s; Pprint.pp_expr e; print_newline(); print_newline()) in
    let e = Parser.parse file in
    let e = Ast.alpha_vary e in
    let _ = (p "input:" e) in
    let _ = let e' = Interpretation.interpret_by_need e in
	    let _ = p "result by need:" e' in
            if e' = Ast.ast_error then raise (Failure "interpret_by_value")
	                          else () in
    let e = Translate.to_call_by_value e in
    let e = Ast.alpha_vary e in
    let _ = (p "by value:" e) in
    let _ = let e' = Interpretation.interpret_by_value e in
	    let _ = p "result by value:" e' in
            if e' = Ast.ast_error then raise (Failure "interpret_by_value")
	                          else () in
    let e = Translate.remove_refs e in
    let _ = (p "by value without refs:" e) in
    let _ = Ast.assert_no_refs e in
    let _ = let e' = Interpretation.interpret_by_value e in
	    let _ = p "result by value without refs:" e' in
            if e' = Ast.ast_error then raise (Failure "interpret_by_value (no refs)")
	                          else () in
    ()

(* the top level function of the program *)
let main () =
    Arg.parse [("-alpha", Arg.Set Pprint.pp_alpha, "print with alpha-renaming");
               ("-noalpha", Arg.Clear Pprint.pp_alpha, "print without alpha-renaming")]
	      test
	      "usage: need <file.cbn>"

let _ = main()
