{
open Need
let lineno = ref 1
}

let alpha = ['A'-'Z' 'a'-'z']
let digit = ['0'-'9']
let ws = [' ' '\t']

rule lex =
  parse
        '/''/'[^'\n']*'\n' { lineno := !lineno + 1; lex lexbuf }
      | ['\n']     { lineno := !lineno + 1; lex lexbuf }
      | ws+        { lex lexbuf }
      | "+"        { PLUS }
      | "-"        { MINUS }
      | "*"        { TIMES }
      | "="        { EQ }
      | "<>"       { NE }
      | "<"        { LT }
      | ">"        { GT }
      | "<="       { LE }
      | ">="       { GE }
      | "ref"      { REF }
      | "!"        { BANG }
      | ":="       { ASSIGN }
      | "("        { LPAREN }
      | ")"        { RPAREN }
      | "zero?"    { ZEROP }
      | "left"     { LEFT }
      | "right"    { RIGHT }
      | "#t"       { TRUE }
      | "#f"       { FALSE }
      | "not"      { NOT }
      | "and"      { AND }
      | "or"       { OR }
      | "if"       { IF }
      | "fn"       { FN }
      | "let"      { LET }
      | "seq"      { SEQ }
      | ","        { COMMA }
      | alpha+     { VAR(Lexing.lexeme lexbuf) }
      | '~'?digit+ { INT(int_of_string(Lexing.lexeme lexbuf)) }
      | eof        { EOF }

{
}
