type var = string * int

val eqvar : var -> var -> bool
val newvar : string -> var

type binop = Plus | Minus | Times | Eq | Lt

type expr = 
  Var of var
| Num of int
| Op of binop * expr * expr
| Zerop of expr
| True
| False
| If of expr * expr * expr
| Left of expr
| Right of expr
| Pair of expr * expr
| Fn of var * expr
| App of expr * expr
| Let of (var * expr) * expr
| Ref of expr
| Deref of expr
| Assign of expr * expr
| Seq of expr * expr
| Loc of int

val alpha_vary : expr -> expr
val assert_no_refs : expr -> unit
val ast_error : expr
val ast_app : expr list -> expr
val ast_fn : var list -> expr -> expr
