type var = string * int

let eqvar (s1,i1) (s2,i2) = i1 = i2

type binop = Plus | Minus | Times | Eq | Lt
 
type expr =
  Var of var
| Num of int
| Op of binop * expr * expr
| Zerop of expr
| True
| False
| If of expr * expr * expr
| Left of expr
| Right of expr
| Pair of expr * expr
| Fn of var * expr
| App of expr * expr
| Let of (var * expr) * expr
| Ref of expr
| Deref of expr
| Assign of expr * expr
| Seq of expr * expr
| Loc of int

let ast_error = App(Num 0, Num 0)

let vctr = ref 0

let newvar s =
  let v = !vctr in
  let _ = vctr := v + 1 in
  (s, v)

let alpha_vary expr =
  let add env s j i = ((s,j),i)::env in

  let rec lookup x k = function
      [] -> raise Not_found
    | (((s, j),i)::rest) -> if (x, k) = (s, j) then
                              (s, i)
                            else
                              lookup x k rest in 

  let bindnew_list vs env =
    List.fold_right
    	(fun (s,j) (vs',env') -> let (_,i) = newvar s in
	                         ((s,i)::vs', add env' s j i)) vs ([],env)
  in

  let bindnew v env = let (vs,env) = bindnew_list (v::[]) env in
                      match vs with (v::vs) -> (v,env)
		                  | [] -> assert false
  in

  let rec alpha env e = match e with
      Var (s,i) -> (try Var(lookup s i env) with Not_found -> Var (s,i))
    | If (e0,e1,e2) -> If (alpha env e0, alpha env e1, alpha env e2)
    | Op (op, e1, e2) -> Op (op, alpha env e1, alpha env e2)
    | Zerop e -> Zerop (alpha env e)
    | Left e -> Left (alpha env e)
    | Right e -> Right (alpha env e)
    | Pair (e1,e2) -> Pair(alpha env e1, alpha env e2)
    | Fn (v, e) -> let (v',env') = bindnew v env in
                   Fn(v', alpha env' e)
    | App (e1,e2) -> App(alpha env e1, alpha env e2)
    | Let ((v,e), body) ->  let (v',env') = bindnew v env in
			    let e' = alpha env' e in
			    let body' = alpha env' body in
			    Let ((v',e'), body')
    | Ref e -> Ref (alpha env e)
    | Deref e -> Deref (alpha env e)
    | Assign (e1, e2) -> Assign (alpha env e1, alpha env e2)
    | Seq (e1, e2) -> Seq (alpha env e1, alpha env e2)
    | e -> e
  in
    alpha [] expr

let rec assert_no_refs e =
  match e with
    Var v -> ()
  | Num n -> ()
  | Op (op, e1, e2) -> (assert_no_refs e1; assert_no_refs e2)
  | Zerop e -> assert_no_refs e
  | True -> ()
  | False -> ()
  | If (e0,e1,e2) -> (assert_no_refs e0; assert_no_refs e1; assert_no_refs e2)
  | Left e -> assert_no_refs e
  | Right e -> assert_no_refs e
  | Pair (e1,e2) -> (assert_no_refs e1; assert_no_refs e2)
  | Fn (v, body) -> assert_no_refs body
  | App (e1, e2) -> (assert_no_refs e1; assert_no_refs e2)
  | Let ((v,e), body) -> (assert_no_refs e; assert_no_refs body)
  | _ -> raise (Failure "unexpected ref found")

let rec ast_fn = function [] -> fun e -> e
		        | v::vs -> fun e -> Fn(v, ast_fn vs e)

let rec ast_app es = match es with e1::e2::[] -> App(e1,e2)
				 | e1::e2::es -> ast_app ((App(e1, e2))::es)
				 | _ -> raise (Failure "not enough args to app")


