let rec pprintLoc l = print_string l

open Ast

let rec pprintAexp = function
    (N n) -> print_string(string_of_int n)
  | (Loc l) -> pprintLoc l
  | (Plus(a1, a2)) -> (print_string "("; pprintAexp(a1); print_string " + "; pprintAexp(a2); print_string ")")
  | (Minus(a1, a2)) -> (print_string "("; pprintAexp(a1); print_string " - "; pprintAexp(a2); print_string ")")
  | (Times(a1, a2)) -> (print_string "("; pprintAexp(a1); print_string " * "; pprintAexp(a2); print_string ")")
    
let rec pprintBexp = function
    (True) -> print_string "true"
  | (False) -> print_string "false"
  | (Equals(a1, a2)) -> (print_string "("; pprintAexp(a1); print_string " = "; pprintAexp(a2); print_string ")")
  | (LessEq(a1, a2)) -> (print_string "("; pprintAexp(a1); print_string " <= "; pprintAexp(a2); print_string ")")
  | (Not(b)) -> (print_string "not "; pprintBexp(b))
  | (And(b1, b2)) -> (print_string "("; pprintBexp(b1); print_string " and "; pprintBexp(b2); print_string ")")
  | (Or(b1, b2)) -> (print_string "("; pprintBexp(b1); print_string " or "; pprintBexp(b2); print_string ")")
    
let rec nSpace = function
    0 -> ()
  | n -> (print_string " "; nSpace(n-1))
    
let rec pprintCom' = function
    (n, Skip) -> (nSpace n; print_string "skip")
  | (n, Break) -> (nSpace n; print_string "break")
  | (n, Assign(l, a)) -> (nSpace n; pprintLoc l; print_string " := "; pprintAexp a)
  | (n, Seq(c1, c2)) -> (pprintCom'(n, c1); print_string ";\n"; pprintCom'(n, c2))
  | (n, Cond(b, c1, c2)) -> (nSpace n; print_string "if "; pprintBexp b; print_string " then {\n";
       pprintCom'(n+2, c1); print_string "\n"; nSpace n; print_string "} else {\n";
       pprintCom'(n+2, c2); print_string "\n"; nSpace n; print_string "}")
  | (n, While(b, c)) -> (nSpace n; print_string "while "; pprintBexp b; print_string " {\n";
       pprintCom'(n+2, c); print_string "\n"; nSpace n; print_string "}")
  | (n, For(l,a1,a2,c)) -> (nSpace n; print_string "for ";pprintLoc l; print_string " := "; 
			    pprintAexp a1; print_string " to "; pprintAexp a2;  
			    print_string " do{\n";
			    pprintCom'(n+2, c); print_string "\n"; nSpace n; print_string "}")

let rec pprintCom c = pprintCom'(0, c)
