{
open Imp
}

let alpha = ['A'-'Z' 'a'-'z']
let digit = ['0'-'9']
let ws = [' ' '\t']

rule lex =
  parse ['\n']     { lex lexbuf }
      | ws+        { lex lexbuf }
      | "+"        { PLUS }
      | "-"        { MINUS }
      | "*"        { TIMES }
      | "("        { LPAREN }
      | ")"        { RPAREN }
      | "{"        { LBRACE }
      | "}"        { RBRACE }
      | "="        { EQUALS }
      | "<="       { LESSEQ }
      | ":="       { ASSIGN }
      | ";"        { SEMI }
      | "true"     { TRUE }
      | "false"    { FALSE }
      | "not"      { NOT }
      | "and"      { AND }
      | "or"       { OR }
      | "skip"     { SKIP }
      | "if"       { IF }
      | "then"     { THEN }
      | "else"     { ELSE }
      |	"while"    { WHILE }
      |	"for"      { FOR }
      |	"to"       { TO }
      | "do"       { DO }
      | "break"    { BREAK }
      | alpha+     { LOC(Lexing.lexeme lexbuf) }
      | '~'?digit+ { INT(int_of_string(Lexing.lexeme lexbuf)) }
      | eof        { EOF }

{
}
