%{
open Ast
%}

%token <int> INT
%token <string> LOC
%token PLUS MINUS TIMES
%token LPAREN RPAREN
%token TRUE FALSE
%token EQUALS LESSEQ
%token NOT AND OR
%token SKIP
%token ASSIGN
%token SEMI
%token IF THEN ELSE
%token WHILE BREAK
%token FOR TO DO
%token LBRACE RBRACE
%token EOF

%type <Ast.com> com
%type <Ast.aexp> aexp
%type <Ast.bexp> bexp
%type <Ast.com> seq
%type <Ast.com> parse

%start parse

%right SEMI
%nonassoc EQUALS
%left LESSEQ
%left OR PLUS MINUS
%left AND TIMES
%right NOT

%%

parse: seq EOF            { $1 }

aexp : INT                { N($1) }
     | LOC                { Loc($1) }
     | aexp PLUS aexp     { Plus($1, $3) }
     | aexp MINUS aexp    { Minus($1, $3) }
     | aexp TIMES aexp    { Times($1, $3) }
     | LPAREN aexp RPAREN { $2 }
     ;

bexp : TRUE               { True }
     | FALSE              { False }
     | aexp EQUALS aexp   { Equals($1, $3) }
     | aexp LESSEQ aexp   { LessEq($1, $3) }
     | NOT bexp           { Not($2) }
     | bexp AND bexp      { And($1, $3) }
     | bexp OR bexp       { Or($1, $3) }
     | LPAREN bexp RPAREN { $2 }
     ;

com  : SKIP               { Skip }
     | BREAK              { Break }
     | LOC ASSIGN aexp    { Assign($1, $3) }
     | IF LPAREN bexp RPAREN THEN LBRACE seq RBRACE ELSE LBRACE seq RBRACE
                          { Cond($3, $7, $11) }
     | FOR LOC EQUALS aexp TO aexp DO LBRACE seq RBRACE
                          { For($2,$4,$6, $9) }
     ;

seq  : com                { $1 }
     | com SEMI seq       { Seq($1, $3) }
     ;

