let test file =
    let com = Parser.parse file in
    let _ = Pprint.pprintCom com in
    let _ = print_string "\n" in
    let state = Interpretation.interpret(com, Interpretation.initialState) in
    Interpretation.lookupState(state, "ANSWER")

let testB file =
    let com = Parser.parse file in
    let _ = Pprint.pprintCom com in
    let _ = print_string "\n" in
    let state = Interpretation.interpretBreak
    	(com, Ast.Skip, [], Interpretation.initialState) in
    Interpretation.lookupState(state, "ANSWER")

let break = ref false

let parse_and_run file =
    let result = (if !break then testB else test) file in
    let _ = print_int result in
    print_string "\n"

(* the top level loop of the program *)
let loop () =
    Arg.parse [("-break", Arg.Set break, "run with break support");
	       ("-nobreak", Arg.Clear break, "run without break support")]
	      parse_and_run
	      "usage: imp [-break] <file.imp>"

let _ = loop()
