(* Use to parse a file in the optional input language into 
 * the optional core language *)
let load_lambda f =
  let e = LambdaP.parse f
    in
      LambdaAst.alpha_vary e

(* Use to run program in the optional core language *)
let run_lambda e 
  = LambdaInterpretation.interpret
    (LambdaAst.alpha_vary e)

(* Use to run program in the optional core language and print out the result *)
let test_lambda e 
  = (LambdaPprint.ppE(run_lambda e); 
     Format.print_newline())


(* Use to translate program in the optional core language 
   into the optional target langauge *)
let lambda_translate e 
  = LambdaAst.alpha_vary 
    (LambdaTranslate.translate
     (LambdaAst.alpha_vary e))

(* Use to run a program in the optional target language *)
let run_lambda_translate e 
  = LambdaInterpretation.interpret2
    (LambdaAst.alpha_vary e)

(* Use to run a program in the optional target language and print out the
result *)
let test_lambda_translate e 
  = (LambdaPprint.ppE(run_lambda_translate e); 
     Format.print_newline())


(* Use to parse a file in input language for HW5 into source languge for HW5 *)
let load_lambda_simple f =
  let e = LambdaSimpleP.parse f
    in
      LambdaSimpleAst.alpha_vary e

(* Use to run program in source language for HW5 *)
let run_lambda_simple e 
  = LambdaSimpleInterpretation.interpret
    (LambdaSimpleAst.alpha_vary e)

(* Use to run program in source language for HW5 and print out the result *)
let test_lambda_simple e 
  = (LambdaSimplePprint.ppE(run_lambda_simple e); 
     Format.print_newline())


(* Use to translate a program in optional target language into source language for HW5 *)
let convert e = LambdaSimpleAst.alpha_vary
                (LambdaSimpleAst.fromLambdaAst 
		 (LambdaAst.alpha_vary e))


(* Use to translate program in source language for HW5 into cps langauge for HW5 *)
let cps_translate e
  = CpsTranslate.cps_translate
    (LambdaSimpleAst.alpha_vary e)

(* Use to run program in cps language for HW5 *)
let run_cps s
  = (try CpsEvaluation.evaluate s
     with (CpsEvaluation.CpsFailure s) -> (print_string s;
					   print_string "\n";
					   raise (CpsEvaluation.CpsFailure s)))

(* Use to run a program in cps language and print out the result *)
let test_cps s
 = (CpsPprint.ppE(run_cps(s));
    Format.print_newline())
  

let optional = ref false

let test_regular file = 
  let e = load_lambda_simple file in
  let _ = (LambdaSimplePprint.ppE e; Format.print_newline()) in
  let _ = (print_endline "the result of source program is:") in
  let _ = test_lambda_simple e in
  let _ = print_endline "and your translation is:" in
  let s_cps = cps_translate e in
  let _ = (CpsPprint.ppS s_cps;Format.print_newline()) in
  let _ = (print_endline "the result of your translation is:") in
  let _ = test_cps s_cps in
  let _ = Format.print_newline() in
  ()

let test_optional file = 
  let e = load_lambda file in
  let _ = (print_endline "the result of fancy source program is:") in
  let _ = test_lambda e in
  let _ = (print_endline "the input for the translation looks like:") in
  let se = convert (lambda_translate e) in
  let _ = (LambdaSimplePprint.ppE se; Format.print_newline()) in
  let _ = print_endline "and your translation is:" in
  let s_cps = cps_translate se in
  let _ = (CpsPprint.ppS s_cps;Format.print_newline()) in
  let _ = (print_endline "the result of your translation is:") in
  let _ = test_cps s_cps in
  let _ = Format.print_newline in
  ()
  

let test file =
  if (!optional) then test_optional file
      else test_regular file

(* the top level function of the program *)
let main () =
    Arg.parse [("-alpha", Arg.Set CpsPprint.ppAlpha, "print with alpha-renaming");
               ("-noalpha", Arg.Clear CpsPprint.ppAlpha, "print without alpha-renaming");
	     ("-optional", Arg.Set optional, "try running with optional language")]
	      test
	      "usage: cpstran [-alpha] [-noalpha] [-optional] <file.lam>"

let _ = main()






