open LambdaAst 
  
exception LambdaTranslate of string
    
let rec translate = function
  Var v -> Var v
(* Primitive operations *)
| Num i -> (Num i)
| Op Plus ->
    let x = newvar "x" in
    let y = newvar "y" in
    Lambda([x],Lambda([y],App [Op Plus; Var x; Var y]))
| Op Times -> 
    let x = newvar "x" in
    let y = newvar "y" in
    Lambda([x],Lambda([y],App [Op Times; Var x; Var y]))
| Op Minus ->
    let x = newvar "x" in
    let y = newvar "y" in
    Lambda([x],Lambda([y],App [Op Minus; Var x; Var y]))
| Op ZeroP -> Op ZeroP
| App ((Op Plus)::es) ->
    List.fold_right (fun e e' -> 
      App [Op Plus; translate e; e'])
    (es)
    (Num 0)

| App ((Op Times)::es) ->
    List.fold_right (fun e e' -> 
      App [Op Times; translate e; e'])
    (es)
    (Num 1)

| App ([Op Minus;e1;e2]) ->
    App [Op Minus; translate e1; translate e2]

(* Case operations *)
| Left e ->
    let x = newvar "x" in
    let y = newvar "y" in
    Lambda([x],Lambda([y], App[Var x; translate e]))
      
| Right e -> 
    let x = newvar "x" in
    let y = newvar "y" in
    Lambda([x],Lambda([y], App[Var y; translate e]))
      
| Case(e,(v1,e1),(v2,e2)) ->           
    let e' = translate e in
    let e1' = translate (Lambda ([v1],e1)) in
    let e2' = translate (Lambda ([v2],e2)) in
    App[App[e'; e1']; e2']
	
(* Pair operations *)

| App[Op(Fst);e] -> 
    let e' = translate e in
    let x = newvar "x" in
    let y = newvar "y" in
    App[e'; Lambda([x],Lambda([y],Var x))]

| App[Op(Snd);e] -> 
    let e' = translate e in
    let x = newvar "x" in
    let y = newvar "y" in
    App[e'; Lambda([x],Lambda([y],Var y))]
	

| Pair (e1,e2) ->
  let f = newvar "f" in
  translate (Lambda([f], App[Var f; e1; e2]))
    

(* Function operations *)

| Lambda ([], e) -> raise (LambdaTranslate "Lambda([]),e")

| Lambda ([x],e) ->
    let e' = translate e
    in 
    Lambda ([x], e')
  

| Lambda (v::vs,e) ->
    let e' = translate (Lambda (vs,e))
    in
    Lambda([v],e')
  

| App [] -> raise (LambdaTranslate "App []")

| App [e] -> App[translate e]

| App (e::es) -> 
  List.fold_left (fun e' e -> App [e';translate e]) 
    (translate e)
    (es)


(* Letrec *)

| Letrec (ves,e) ->
(* lazy Y combinator *)
    let yy = 
      let f = newvar "f" in
      let x = newvar "x" in
      Lambda([f],
	      App[Lambda([x],App[Var f;App[Var x; Var x]]);
		  Lambda([x],App[Var f;App[Var x; Var x]])])
    in
      
(* strict Y combinator **

   let yy' = 
     let y = newvar "y" in
     let f = newvar "f" in
     Lambda([y],
         Lambda([f],App[Var f;App[App[Var y;Var y];Var f]]))

   
   let yy = App[yy';yy']
*)
(* strict Y combinator
   let yy =
   let f = newvar "f" in
   let x = newvar "x" in
   let y = newvar "y" 
   in Lambda([f],App[Lambda([x],Lambda([y],App[Var f;
   App[Var x; Var x];
   Var y]));
   Lambda([x],Lambda([y],App[Var f;
   App[Var x; Var x];
   Var y]))])
*)


    let (vs,es) = List.split ves in

	  (* List of arguments (g \v1...vn.e1) ... (g \v1...vn.en) *)
    let g = newvar "g" in
    let y = newvar "y" in
    let args = List.map (fun exp -> App[Var g; Lambda(vs,exp)]) es in
    let ff = Lambda([g],Lambda([y],App(Var y::args))) in
	  (* Apply ff recursively to e abstracted over vs *)
    translate (App[yy;ff;Lambda(vs,e)])
	  

| e -> raise (LambdaTranslate "unimplemented")
    
let transTrue = translate astTrue
let transFalse = translate astFalse
    
