let ppAlpha = ref false

open LambdaSimpleAst
open Format

let pp = print_string

let rec ppVar (s, i) =
  if !ppAlpha then pp (s^(string_of_int i)) else pp s

let ppPrimop = function
  Plus ->  pp "+"
| Times -> pp "*"
| Minus -> pp "-"

let rec ppExpr e = 
  match e with
    Var v -> ppVar v
  | Lambda (v, e) -> (open_box 0;
		      pp "(fn ";
		      pp "(";
		      ppVar v;
		      pp ")";
		      print_break 1 1;
		      ppExpr e;
		      pp ")";
		      close_box()  
		     )
  | App(e1, e2) -> (open_box 0;
		    pp "(";
		    ppExpr e1;
		    print_break 1 1;
		    ppExpr e2;
		    pp ")";
		    close_box()  
		   )  
  | Num i  -> print_int i
  | ZeroP(e) -> (open_box 0;
		 pp "(zero? ";
		 ppExpr e;
		 pp ")";
		 close_box()  
		)
  | IsZero(e) -> (open_box 0;
		  pp "(iszero? ";
		  print_break 1 1;
		  ppExpr e;
		  pp ")";
		  close_box()  
		 )
  | Op (p, e1, e2) -> (open_box 0;
		       pp "(";
		       open_box 0;
		       ppPrimop p;
		       print_break 1 1;
		       ppExpr e1;
		       print_break  1 1;
		       ppExpr e2;
		       close_box()  ;
		       pp ")";
		       close_box()  
		      )
  | If (b, e1, e2) -> (open_box 0;
		       pp "(if ";
		       open_box 0;
		       ppExpr b;
		       print_break 1 1;
		       ppExpr e1;
		       print_break 1 1;
		       ppExpr e2;
		       close_box()  ;
		       pp ")";
		       close_box()  
		      )
  | True -> pp "#t"
  | False -> pp "#f"


let ppE e = (ppExpr e; print_flush())






    
