%{
open LambdaSimpleAst
%}

%token <int> INT
%token <string> VAR
%token PLUS MINUS TIMES ISZERO
%token LPAREN RPAREN
%token FN
%token NOT TRUE FALSE IF
%token EOF

%type <LambdaSimpleAst.expr> parse
%type <LambdaSimpleAst.expr> expr

%start parse

%%

parse: expr EOF           { $1 }

expr : INT                { Num $1 }
     | VAR                { Var ($1, -1) }
     | TRUE               { True }
     | FALSE              { False }
     | LPAREN ISZERO expr RPAREN {IsZero($3)}
     | LPAREN PLUS expr expr RPAREN { Op(Plus, $3, $4) }
     | LPAREN TIMES expr expr RPAREN { Op(Times, $3, $4) }
     | LPAREN MINUS expr expr RPAREN { Op(Minus, $3, $4) }
     | LPAREN IF expr expr expr RPAREN { If($3, $4,$5) }
     | LPAREN FN LPAREN VAR RPAREN expr RPAREN 
	 { Lambda(($4, -1), $6) }
     | LPAREN expr expr RPAREN { App($2,$3) }
     ;
