type var = string * int

val eqvar : var -> var -> bool
val newvar : string -> var

type primop = 
    Plus                   
  | Times
  | Minus

type expr =
    Var of var
  | Num of int
  | ZeroP of expr
  | IsZero of expr
  | Lambda of var * expr
  | App of expr * expr
  | Op of primop * expr * expr
  | True
  | False
  | If of expr * expr * expr

val alpha_vary : expr -> expr
val alpha_equiv : expr -> expr -> bool

val transTrue : expr
val transFalse : expr
val fromLambdaAst : LambdaAst.expr -> expr
val toLambdaAst : expr -> LambdaAst.expr
val ftLambdaAst : LambdaAst.expr -> LambdaAst.expr
