1let ppAlpha = ref false

open LambdaAst 
open Format
let pp = print_string
let rec ppVar  (s, i) =
  if !ppAlpha then pp (s^(string_of_int i)) else pp s

let rec ppList pf list = 
  let rec ppListH = function
      [] -> ()
    | x::[] -> pf x
    | x1::l -> (pf x1;  print_break 1 0; ppListH l )
  in
  (open_box 0;
   ppListH list;
   close_box())

let rec ppPrimop  p = 
  match p with 
    Plus ->  pp "+"
  | Times -> pp "*"
  | Minus -> pp "-"
  | ZeroP -> pp "zero?"
  | Fst -> pp "fst"
  | Snd -> pp "snd"

let rec ppExpr  e = 
  match e with
    Var v -> ppVar  v
  | Num i -> print_int  i
  | Op p -> ppPrimop  p
  | Lambda(vl, e) -> 
      (pp "(fn ";
       open_box 2;
       pp "(";
       ppList ppVar vl;
       pp ")";
       print_break  1 2;
       ppExpr  e;
       close_box() ;
       pp ")"
      )
  | App el -> 
      (open_box 0;
       pp "(";
       ppList ppExpr el;
       pp ")";
       close_box() )
  | Pair (e1,e2) -> 
      (open_box 0;
       pp "<";
       ppExpr  e1;
       pp ",";
       ppExpr  e2;
       pp ">";
       close_box() )
  | Letrec (vel, e) -> 
      (pp "(letrec ";
       open_box 2;
       pp "(";
       ppList (fun (v, e) -> 
	 (pp "(";
	  ppVar  v;
	  print_break  1 0;
	  ppExpr  e;
	  pp ")"))
	 vel;
       pp ")";
       print_break  1 2;
       ppExpr  e;
       close_box() ;
       pp ")")
  | Case(e,(v1,e1),(v2,e2)) -> 
      (pp "(case ";
       open_box 2;
       ppExpr  e;
       (pp "(";
	ppVar  v1;
	print_break  1 0;
	ppExpr  e1;
	pp ")");
       (pp "(";
	ppVar  v2;
	print_break  1 0;
	ppExpr  e2;
	pp ")");
       close_box() ;
       pp ")")
  | Left e -> 
      (pp "(left ";
       ppExpr  e;
       pp ")")
  | Right e -> 
      (pp "(right ";
       ppExpr  e;
       pp ")")

let ppE e = (ppExpr e; print_flush())




