%{
open LambdaAst
open LambdaTranslate

let rec do_if e e1 e2 = App[astIf; e; e1; e2]
let rec do_list = function
    [] -> Right(Num 0)
  | (e::es) -> Left(Pair(e, do_list es))
let rec do_and = function
		[] -> astTrue
	      | (e::es) -> do_if e (do_and es) astFalse
let rec do_or = function
		[] -> astFalse
	      | (e::es) -> do_if e astTrue (do_or es)
let rec do_head e = App[astHead; e]
let rec do_tail e = App[astTail;e]
let rec do_cons e e' = App[astCons; e; e']
let rec do_nilp e = App[astNilP; e]
%}

%token <int> INT
%token <string> VAR
%token PLUS MINUS TIMES ZERO
%token LPAREN RPAREN COMMA
%token LEFT RIGHT CASE
%token LBRACK RBRACK NIL HEAD TAIL CONS
%token FN LETREC
%token LANGLE RANGLE FST SND
%token AND OR NOT TRUE FALSE IF
%token REF BANG ASSIGN SEQ
%token LBRACK RBRACK
%token EOF

%type <LambdaAst.expr> parse
%type <LambdaAst.expr> expr
%type <LambdaAst.var list> vs
%type <LambdaAst.expr list> es
%type <LambdaAst.primop> prim

%start parse

%%
parse: expr EOF           { $1 }

expr : INT                { Num $1 }
     | VAR                { Var ($1, -1) }
     | TRUE               { astTrue }
     | FALSE              { astFalse }
     | prim               {Op($1)}
     | LPAREN AND expr expr es RPAREN { do_and ($3::$4::$5) }
     | LPAREN OR expr expr es RPAREN { do_or ($3::$4::$5) }
     | LPAREN LEFT expr RPAREN { Left $3 }
     | LPAREN RIGHT expr RPAREN { Right $3 }
     | LPAREN IF expr expr expr RPAREN { (do_if $3 $4 $5) }
     | LPAREN CASE expr 
	 LPAREN VAR expr RPAREN
	 LPAREN VAR expr RPAREN RPAREN    
	 {Case($3, (($5,-1),$6),
		    (($9,-1),$10))}
     | LPAREN FN LPAREN vs RPAREN expr RPAREN { Lambda($4, $6) }
     | LPAREN expr expr es RPAREN { App ($2::$3::$4) }
     | LPAREN LETREC LPAREN ves RPAREN expr RPAREN {
              Letrec($4, $6) }
     | LANGLE expr COMMA expr RANGLE { Pair($2,$4) }
     | LBRACK es RBRACK               {do_list $2}
     ;

prim : PLUS             {Plus}
     | TIMES            {Times}
     | MINUS            {Minus}
     | ZERO             {ZeroP}
     | FST              {Fst}
     | SND              {Snd}
	;

vs :			{ [] }
	| VAR vs	{ ($1,-1)::$2 }
	;

es:			{ [] }
	| expr es		{ $1::$2 }
	;

ves :			{ [] }
	| LPAREN VAR expr RPAREN ves	{ (($2,-1),$3)::$5 }
	;

