{
open LambdaParser
let lineno = ref 1
}

let alpha = ['A'-'Z' 'a'-'z']
let digit = ['0'-'9']
let ws = [' ' '\t']
let newline = ('\r' | '\n' | "\r\n")
rule lex =
  parse
        '/''/'[^'\n' '\r']*newline { lineno := !lineno + 1; lex lexbuf }
      | newline    { lineno := !lineno + 1; lex lexbuf }
      | ws+        { lex lexbuf }
      | "+"        { PLUS }
      | "-"        { MINUS }
      | "*"        { TIMES }
      | "("        { LPAREN }
      | ")"        { RPAREN }
      |	"<"        { LANGLE }
      |	">"        { RANGLE }
      |	"["        { LBRACK }
      |	"]"        { RBRACK }
      |	"nil?"     { NIL }
      |	"hd"       { HEAD}
      |	"tl"       { TAIL}
      |	"cons"     { CONS }
      |	"zero?"    { ZERO }
      |	"and"      { AND }
      |	"or"       { OR }
      | "#t"       { TRUE }
      | "#f"       { FALSE }
      | "fn"       { FN }
      | "if"       { IF }
      |	"case"     { CASE }
      |	"left"     { LEFT }
      |	"right"    { RIGHT }
      |	"fst"      { FST }
      |	"snd"      { SND }
      |	"letrec"   { LETREC }
      |	","        { COMMA }
      | alpha+     { VAR(Lexing.lexeme lexbuf) }
      | '-'?digit+ { INT(int_of_string(Lexing.lexeme lexbuf)) }
      | eof        { EOF }
      |	_          {raise (Failure ("Invalid character found during lexing:"^(Lexing.lexeme lexbuf)))}

{
}








