(*    structure PP = LambdaLambdaPprintrint*)
exception RuntimeError of string

open LambdaAst
let rec subst e v e' =
  match e' with
    Var v' -> if eqvar v v' then e else e'
  | Num i -> Num i
  | Op p -> Op p
  | Lambda (vl, expr) -> (* Assumes alpha-conversion, 
			    so capture is not possible *)
      Lambda (vl, subst e v expr)
  | App el -> App (List.map (subst e v) el)
  | Pair(e1,e2) -> Pair(subst e v e1, subst e v e2)
  | Case(e',(v1,e1),(v2,e2)) -> Case(subst e v e', 
				     (v1,subst e v e1), 
				     (v2,subst e v e2))
  | Left(e') -> Left(subst e v e')
  | Right(e') -> Right(subst e v e')
  | Letrec (vel, expr) -> 
      let (vs, es) = List.split vel in
      let es' = List.map (subst e v) es in
      let vel' = List.combine vs es' in
      Letrec (vel', subst e v expr)

let rec interpret e = 
  let rec interpPrim p args =
    let rec eletToInt l =
      List.map 
	(fun e -> match interp e with
	  Num i -> i
	| _ -> 
	    (LambdaPprint.ppE e; raise (RuntimeError ("+ or * applied to non-int"))))
	l
    in
    match p with
      Plus -> Num(List.fold_left (fun x y -> x+y) 0 (eletToInt args))
    | Times -> Num(List.fold_left (fun x y ->x*y) 1 (eletToInt args))
    | Minus -> (match args with
	[e1; e2] -> 
	  let v1 = interp e1 in
	  let v2 = interp e2 in
	  (match (v1, v2) with
	    (Num n1, Num n2) -> Num(n1-n2)
	  | _ -> raise (RuntimeError 
			  ("- applied to bad args")))
      | _ -> raise 
	    (RuntimeError ("- applied to wrong number of args")))
    | ZeroP -> (match args with
	[e] -> let v = interp e in
	(match v with
	  Num 0 -> astTrue
	| _ -> astFalse)
      | _ -> raise (RuntimeError ("zero? applied to wrong number of args")))
    | Fst -> (match args with 
	[e] -> let v = interp e in 
	(match v with
	  Pair(e1,e2) -> let v' = interp e1 in v'
	| _ -> raise (RuntimeError ("fst applied to non-pair")))
      | _ -> raise (RuntimeError ("fst applied to wrong number of arguments")))
    | Snd -> (match args with 
	[e] -> let v = interp e in 
	(match v with
	  Pair(e1,e2) -> let v' = interp e2 in v' 
	| _ -> raise (RuntimeError ("snd applied to non-pair")))
      | _ -> raise (RuntimeError ("snd applied to wrong number of arguments")))


  and interp e =
    match e with
      Var v -> Var v
    | App [] -> raise (RuntimeError "Null Application")
    | App (f::args) -> 
	let f = interp f in
	(match f with
	  Op p -> interpPrim p args
	| Lambda (vars, e) -> 
	    (match (vars, args) with 
	      ([], []) ->
		interp e
	    | (vs, []) -> 
		Lambda (vs, e)
	    | (v1::vrest, a1::arest) ->
		let e' = subst a1 v1 (alpha_vary e) 
		in
		interp (App ((Lambda (vrest, e')):: arest)) 
	    | _ -> raise (RuntimeError 
		"fun applied to wrong number of args"))
	| e -> (LambdaPprint.ppE e;
		raise (RuntimeError "Applied non-let recction to args")))
    | Letrec (vel, e) -> 
	let e' = List.fold_left (fun e (v, a) ->
	  subst a v e)
	    e vel in
	let e'' = List.fold_left (fun e (v, _) ->
	  subst (alpha_vary (Letrec (vel, Var v))) v e)
	    e' vel
	in
	interp e''
	  
    | Case(e,(v1,e1),(v2,e2)) -> 
	let s = interp e 
	in (match s with
	  Left(e') -> interp (subst (alpha_vary e') v1 e1)
	| Right (e') -> interp (subst (alpha_vary e') v2 e2)
	    | _ -> raise (RuntimeError "Case applied to non [left/right]"))
    | e -> e
  in
  try (interp e) with (RuntimeError s) -> (print_string (s^"\n"); App [])



let rec interpret2 e = 
let rec interpPrim p args =
let rec eletToInt l =
  List.map (fun e -> match interp e with
    Num i -> i
  | _ -> (LambdaPprint.ppE e; raise (RuntimeError ("+ or * applied to non-int"))))
    l
in
match p with
  Plus -> Num(List.fold_left (fun x y -> x+y) 0 (eletToInt args))
| Times -> Num(List.fold_left (fun x y -> x*y ) 1 (eletToInt args))
| Minus -> (match args with
    [e1; e2] -> 
      let v1 = interp e1 in
      let v2 = interp e2
      in
      (match (v1, v2) with
	(Num n1, Num n2) -> Num(n1-n2)
      | _ -> raise (RuntimeError 
		      ("- applied to bad args")))
  | _ -> raise 
	(RuntimeError ("- applied to wrong number of args")))
| ZeroP -> (match args with 
    [e] -> let v = interp e in
    (match v with
      Num 0 -> LambdaTranslate.transTrue
    | _ -> LambdaTranslate.transFalse)

  | _ -> raise (RuntimeError ("zero? applied to wrong number of args")))

| (Fst|Snd) -> raise (RuntimeError "Unsupported primop")


and interp e =
  match e with
    Var v -> Var v
  | App [] -> raise (RuntimeError "Null Application")
  | App (f::args) -> 
      let f = interp f in
      (match f with
	Op ZeroP -> interpPrim ZeroP args
      | Op p -> (if List.length args <> 2 then
	  raise (RuntimeError "primop not applied to 2 args")
      else
	  interpPrim p args)
      | Lambda (vars, e) -> 
	  if (List.length vars = 1) && 
	      (List.length args = 1) then
	    let e' = 
	      List.fold_left (fun e (v, a) ->
		subst a v (alpha_vary e)) 
		e
		(List.combine vars args)
	    in
	    interp e'

	  else raise (RuntimeError 
			"fun applied to wrong number of args")
      | e ->(LambdaPprint.ppE e;
	     raise (RuntimeError "Applied non-let function to args")))

  | Letrec (vel, e) -> 
      raise (RuntimeError "Letrec not supported")
  | Num n -> Num n
  | Op p -> (match p with 
      (Plus | Times | Minus | ZeroP) -> Op p
    | _ -> raise (RuntimeError "Op not supported"))
  | Lambda (vl, e) -> 
      if List.length vl <> 1 then
	(raise (RuntimeError "Lambda has more than one arg"))
      else Lambda (vl, e)
  | Case (e,(v1,e1),(v2,e2)) -> raise (RuntimeError "Case not supported")
  | Pair (e1,e2) -> raise (RuntimeError "Pair not supported")
  | Left e -> raise (RuntimeError "Left not supported")
  | Right e -> raise (RuntimeError "Right not supported")
in
try (interp e) with (RuntimeError s) -> (print_string (s^"\n"); App [])
    




