type var = string * int

val eqvar : var -> var -> bool
val newvar : string -> var

type primop = 
    Plus                   
  | Times
  | Minus
  | ZeroP
  | Fst
  | Snd

type expr =
    Var of var
  | Num of int
  | Op of primop
  | Lambda of var list * expr
  | App of expr list
  | Pair of expr * expr
  | Case of expr * (var * expr) * (var * expr)
  | Left of expr
  | Right of expr
  | Letrec of (var * expr) list * expr

val alpha_vary : expr -> expr
val alpha_equiv : expr -> expr -> bool

  (* expressions implementing boolean operations using sums *)
val astTrue : expr
val astFalse : expr
val astIf : expr
  (* expressions implementing list operations using sums and products *)
val astHead : expr
val astTail : expr
val astCons : expr
val astNil : expr
val astNilP : expr
