let ppAlpha = ref true

open CpsAst
open Format

let pp = print_string

let ppVar = fun (s, i) ->
  if !ppAlpha then pp (s ^ (string_of_int i))
  else pp s

let ppPrimop  = function 
	Plus ->  pp "+"
      | Times -> pp "*"
      | Minus -> pp "-"

let rec ppList pf list = 
  let rec ppListH = function
      [] -> ()
    | x::[] -> pf x
    | x1::l -> (pf x1;  print_break 1 0; ppListH l )
  in
  (open_box 0;
   ppListH list;
   close_box())

let rec pp_expr  = function
    Var v -> ppVar   v
  | Lam (v, s) -> (open_box 0;
		   pp "\\";
		   ppVar   v;
		   pp ". ";
		   print_break 2 2;
		   pp_stm   s;
		   close_box())  
  | Halt -> pp "halt"
  | Tuple vl -> (open_box 0;
		 pp "<";
		 ppList ppVar  vl;
		 pp ">";
		 close_box()  
		)
  | Index (v,n) -> (ppVar   v;
		    pp "[";
		    print_int   n;
		    pp "]")
  | Op (p, v1, v2) -> (ppVar   v1;
		       pp " ";
		       ppPrimop   p;
		       pp " ";
		       ppVar   v2)
  | Num i -> print_int   i

and pp_stm  = function
    App (v1,v2) -> (ppVar   v1;
		    pp " ";
		    ppVar   v2)
  | Ifz (v,s1,s2) -> (open_box     0;
		      pp "ifz ";
		      ppVar   v;
		      print_break 1 1;
		      pp "[";
		      pp_stm   s1;
		      pp "]";
		      force_newline();
		      print_break 1 1;
		      pp "[";
		      pp_stm   s2;
		      pp "]";
		      close_box()  
		     )
  | Let (v,e,s) -> (open_box     0;
		    pp "let ";
		    ppVar   v;
		    pp " = ";
		    pp_expr   e;
		    pp " in";
		    force_newline();
		    print_break 2 2;
		    pp_stm   s;
		    close_box()  
		   )
	 
let ppE e = (pp_expr e; print_flush())
let ppS s = (pp_stm s; print_flush())


