open CpsAst

type value = 
    Lam' of var * stm
  | Halt'
  | Tuple' of value list
  | Num' of int

let toExp = function
    (Lam'(v,s)) -> Lam(v,s)
  | Halt' -> Halt
  | (Tuple' _) -> Tuple []
  | Num'(n) -> Num(n)

let is_value = function
    (Lam(x,s)) -> true
  | (Halt) -> true
  | (Num(n)) -> true
  | (Tuple(vs)) -> true
  |  _ -> false

    (* type value = exp such that is_value = true *)

exception CpsFailure of string

    (* type env = var -> value *)
let empty_env = []
let extend env x v = (x,v)::env
let rec lookup x = function
    [] ->
      let (xs, xi) = x in
      raise (CpsFailure ("Unbound variable " ^ xs ^
			 (string_of_int xi)))
  | ((y,v)::env) ->
      if eqvar x y
      then v
      else lookup x env

    (* val step : env -> exp -> val *)
let rec step env  = function
    Op(Plus,x0,x1) -> 
      (match (lookup x0 env, lookup x1 env) with
	(Num'(n),Num'(m)) -> Num'(n+m)
      | _ -> (CpsPprint.ppE (Op(Plus,x0,x1)); 
	      print_string "\n";
	      raise (CpsFailure "Added non-integer")))
  | Op(Minus,x0,x1) ->
      (match (lookup x0 env, lookup x1 env) with
	(Num'(n),Num'(m)) -> Num'(n-m)
      | _ -> (CpsPprint.ppE (Op(Minus,x0,x1)); 
	      print_string "\n";
	  raise (CpsFailure "Subtracted non-integer")))
  | Op(Times,x0,x1) -> 
      (match (lookup x0 env, lookup x1 env) with
	(Num'(n),Num'(m)) -> Num'(n*m)
      | _ -> (CpsPprint.ppE (Op(Times,x0,x1)); 
	      print_string "\n";
	      raise (CpsFailure "Multiplied non-integer")))
  | Index (x,n) -> 
    (match lookup x env with
      Tuple'(vs) -> 
	(try List.nth vs n with Failure nth
	  -> (CpsPprint.ppE (Index (x,n));
	      print_string "\n";
	      raise (CpsFailure "Index out of range")))
      | v -> (CpsPprint.ppE (Index(x,n));
	      print_string "\n";
	      raise (CpsFailure "Indexed non-tuple")))
  | Var(x) -> lookup x env
  | Lam(v,s)-> Lam'(v,s)
  | Halt -> Halt'
  | Tuple(vs) -> Tuple' 
	(List.map 
	   (fun v -> lookup v env) vs)
  | Num(n) -> Num'(n)

    (* val eval : env -> stm -> val *)
and eval env = function
   App(x0,x1) -> (match lookup x0 env with
     Lam'(x,s) -> eval (extend empty_env x (lookup x1 env)) s
   | Halt' -> lookup x1 env
   | _ -> (CpsPprint.ppS (App(x0,x1));
	   print_string "\n";
	   raise (CpsFailure "Attempt to apply non-function")))
  | Ifz (x,s1,s2) -> (match lookup x env with
      Num'(0) -> eval env s1
    | Num'(n) -> eval env s2
    | _ -> (CpsPprint.ppS (Ifz (x,s1,s2));
	    raise (CpsFailure "Attempt to ifz non-integer")))
  | Let (x,e,s) ->
    let v = step env e in
    eval (extend env x v) s

    (* val evaluate : stm -> val *)
let evaluate s = toExp (eval empty_env s)
