DSORT(1)                           |STAT                      June 17, 1986

NAME
     dsort - multiple key data-file sorting filter

SYNOPSIS
     dsort [-aceinr] [-l lines] [[type][column-range]] ...

DESCRIPTION
     _d_s_o_r_t sorts data it reads from the standard input.  It sorts lines
     based on numerical or alphabetical values in whitespace-separated
     columns.  For when two columns have the same value, you can supply
     further sorting columns to break ties.  _d_s_o_r_t sorts by looking at
     columns you choose, and orders lines so that the data or labels in the
     chosen columns are ordered.  You can name the specific column numbers
     you want, and you can use the M-N notation to specify a sequence, from
     M to N, of columns.  Ranges can be from small to large or from large
     to small column numbers.  If you don't supply columns to sort with,
     _d_s_o_r_t uses column 1, then 2, then 3, and so on, until it finds a
     difference, or all columns are used.

     You can supply the method for comparing column values: a, for
     alphabetical, i, for integer, n, for most other numbers, including
     those with decimal points, or e, for sorting all types of numbers,
     even ones with exponential scientific notation.  If you do not supply
     the type of sort, _d_s_o_r_t chooses the one that is best suited for the
     data, although this makes _d_s_o_r_t do some extra work.  For alphabetical
     sorts, you can request a case-insensitive sort with c; that would make
     _h_e_l_l_o match _H_e_l_l_o and _H_E_L_L_O. You can reverse the sort from the default
     ascending order to descending order with r. These sorting types can be
     specified globally for all columns at once with command line options.
     Global types can be over-ridden by supplying options for specific
     columns or ranges of columns.

OPTIONS
     -a   Sort fields by alphabetic ordering of columns.

     -c   Use a case-insensitive comparison for alphabetic comparisons.
          When used as a type modifier for a specific range of columns,
          this also forces alphabetic sorting.  As a command line option,
          it only modifies the sorting of alphabetic columns.

     -e   Sort fields by exponential notation ordering of columns.  This is
          the only true numeric sort that works for all numbers: integers,
          numbers with decimal points, and exponential (scientific)
          notation numbers.  But it is a lot slower than the other sorting
          options, especially on machines without floating point hardware.

     -i   Sort fields by integer ordering of columns.

     -l lines
          Set the maximum number of lines to be read.

     -n   Sort fields by special numeric ordering of columns.  Numbers with
          decimal points are allowed, and compared by a special fast
          comparison method that is almost as fast as integer sorting.

     -r   Reverse the order of comparison for sorting options.

EXAMPLES
     Suppose the file _e_x._d_a_t has the contents below.  If you did not
     specify column types, _d_s_o_r_t would infer that columns 1 and 2 were to
     be sorted alphabetically, column 3, as integers, and column 4,
     numerically.

     _e_x._d_a_t   # file with four columns (alpha, alpha, integer, numerical)
     red       high      1         3.14
     blue      low       2         1.62
     green     high      6         2.54
     green     low       4         2.71
     blue      high      3         1
     red       low       5         1

     _d_s_o_r_t  <  _e_x._d_a_t   # sort by column 1, then 2, then 3, then 4
     blue      high      3         1
     blue      low       2         1.62
     green     high      6         2.54
     green     low       4         2.71
     red       high      1         3.14
     red       low       5         1

     _d_s_o_r_t  _i_3  <  _e_x._d_a_t   # sort column 3 in ascending order
     red       high      1         3.14
     blue      low       2         1.62
     blue      high      3         1
     green     low       4         2.71
     red       low       5         1
     green     high      6         2.54

     _d_s_o_r_t  _r_n_4  _3  <  _e_x._d_a_t   # numerically sort column 4 in reverse order, then 3
     red       high      1         3.14
     green     low       4         2.71
     green     high      6         2.54
     blue      low       2         1.62
     blue      high      3         1
     red       low       5         1

     _d_s_o_r_t  _r_n_4  _r_3  <  _e_x._d_a_t   # reverse numerical sort of column 4 and then 3
     red       high      1         3.14
     green     low       4         2.71
     green     high      6         2.54
     blue      low       2         1.62
     red       low       5         1
     blue      high      3         1

     _d_s_o_r_t  _2-_1  <  _e_x._d_a_t   # sort by column 2, then column 1 within ties in 2
     blue      high      3         1
     green     high      6         2.54
     red       high      1         3.14
     blue      low       2         1.62
     green     low       4         2.71
     red       low       5         1

LIMITS
     Use the -L option to determine the program limits.
