/*IND-version2.0
 *   IND 2.0 released 9/15/92   contact: ind@kronos.arc.nasa.gov
 *   by Wray Buntine (and others, see IND/README)
 *   NASA Ames Research Center, MS 269-2, Moffett Field, CA 94035
 */

/*
 *              Various bits and pieces used by BITSET.h and BITARRAY.h
 */
#define BITS
#include <stdio.h>
#include "BITSET.h"
#include "Lib.h"

#if BITSETMAX <= 32
/*
 *	bit_univ[s] = universal set of size s
 */
unsigned int bit_univ[] = 
 {0,01,03,07,017,037,077,0177,0377,0777,01777,03777,07777,
  017777,037777,077777,0177777,0377777,0777777,
  01777777,03777777,07777777,017777777,037777777,077777777,
  0177777777,0377777777,0777777777,01777777777,03777777777,07777777777,
  017777777777,037777777777};

/*
 *	bit_cv[set] = cardinality of byte set "set"
 */
unsigned char bit_cv[] = 
 {0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
  1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8 };

#ifdef  XXXstuff
/*
 *	bit_nx[set] = first bit set in byte set "set"
 */
unsigned char bit_nx[] = 
 {0,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
  5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
  6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
  5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
  7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
  5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
  6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
  5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0 };

/*
 *	bit_af[set] = zeros first set bit in byte set "set"
 */
unsigned char bit_af[256] =
 {0,0,0,2,0,4,4,6,0,8,8,10,8,12,12,14,
  0,16,16,18,16,20,20,22,16,24,24,26,24,28,28,30,
  0,32,32,34,32,36,36,38,32,40,40,42,40,44,44,46,
  32,48,48,50,48,52,52,54,48,56,56,58,56,60,60,62,
  0,64,64,66,64,68,68,70,64,72,72,74,72,76,76,78,
  64,80,80,82,80,84,84,86,80,88,88,90,88,92,92,94,
  64,96,96,98,96,100,100,102,96,104,104,106,104,108,108,110,
  96,112,112,114,112,116,116,118,112,120,120,122,120,124,124,126,
  0,128,128,130,128,132,132,134,128,136,136,138,136,140,140,142,
  128,144,144,146,144,148,148,150,144,152,152,154,152,156,156,158,
  128,160,160,162,160,164,164,166,160,168,168,170,168,172,172,174,
  160,176,176,178,176,180,180,182,176,184,184,186,184,188,188,190,
  128,192,192,194,192,196,196,198,192,200,200,202,200,204,204,206,
  192,208,208,210,208,212,212,214,208,216,216,218,216,220,220,222,
  192,224,224,226,224,228,228,230,224,232,232,234,232,236,236,238,
  224,240,240,242,240,244,244,246,240,248,248,250,248,252,252,254};
#endif
#endif

/* 
 *      used as intermediate store in #defined routines in BITSET.h
 */
union cxitype cxic;

/*
 *	return index of nth element in set
 */
int
getset_nth(set,n)
int	n;
bitset  set;
{
	int	index=0;
	if ( n<=0 ) return 0;
	for ( ; set; ) {
	    if ( n <= bit_cv[set&0xff] ) {
		for (  ; set; set>>=1, index++ )
		    if ( set&1 ) 
			if ( --n<= 0 ) return index;
		error("set_nth internal error","");
	    } else {
		index += 8;
		n -= bit_cv[set&0xff];
		set >>= 8;
	    }
	}
	return index;
}

