package rubik.geometry;

import java.awt.Polygon;
import java.awt.geom.Point2D;

public class TwoDPoint extends Point2D.Double {
   
   public static final TwoDPoint ZERO = new TwoDPoint(0, 0);
   
   public TwoDPoint(double x, double y) {
      super(x, y);
   }

   public TwoDPoint(int x, int y) {
      super(x, y);
   }

   public TwoDPoint(TwoDPoint p) {
      super(p.x, p.y);
   }
   
   public TwoDPoint plus(TwoDPoint p) {
      return new TwoDPoint(x + p.x, y + p.y);
   }

   public TwoDPoint minus(TwoDPoint p) {
      return new TwoDPoint(x - p.x, y - p.y);
   }

   public TwoDPoint scalarMult(double d) {
      return new TwoDPoint(d*x, d*y);
   }

   public void place(Polygon p) {
      final int scaleFactor = 320;
      p.addPoint((int)(scaleFactor * x), (int)(scaleFactor * y));
   }

   public String toString() {
      return String.format("[x=%.3f, y=%.3f]", x, y);
   }
}