package rubik.geometry;

public class Matrix {
   public ThreeDPoint x;
   public ThreeDPoint y;
   public ThreeDPoint z;
   
   public static final Matrix IDENTITY = new Matrix();

   // represented in row major order
   public Matrix(ThreeDPoint x, ThreeDPoint y, ThreeDPoint z) {
      this.x = x;
      this.y = y;
      this.z = z;
   }

   public Matrix() {
      // initialize with identity
      this(new ThreeDPoint(1, 0, 0),
           new ThreeDPoint(0, 1, 0),
           new ThreeDPoint(0, 0, 1));
   }
   
   public Matrix(int[][] m) {
      this(new ThreeDPoint(m[0][0], m[0][1], m[0][2]),
           new ThreeDPoint(m[1][0], m[1][1], m[1][2]),
           new ThreeDPoint(m[2][0], m[2][1], m[2][2]));
   }
 
   // matrix-vector product
   // returns this * p
   public ThreeDPoint mult(ThreeDPoint p) {
      return new ThreeDPoint(x.dotProduct(p), y.dotProduct(p), z.dotProduct(p));
   }
   
   // matrix-matrix product
   // returns this * m
   public Matrix mult(Matrix m) {
      Matrix mT = m.transpose();
      return new Matrix(mult(mT.x), mult(mT.y), mult(mT.z)).transpose();
   }

   public Matrix transpose() {
      return new Matrix(new ThreeDPoint(x.x, y.x, z.x),
                        new ThreeDPoint(x.y, y.y, z.y),
                        new ThreeDPoint(x.z, y.z, z.z));
   }
   
   public void round() {
      x.round();
      y.round();
      z.round();
   }

   public int hashCode() {
      return (int)(x.hashCode() + 3*y.hashCode() + 7*z.hashCode());
   }
   
   public boolean equals(Object o) {
      try {
         Matrix m = (Matrix)o;
         return x.equals(m.x) && y.equals(m.y) && z.equals(m.z);
      } catch (Exception e) {
         return false;
      }
   }
   
   public String toString() {
      return String.format("%s\n%s\n%s", x, y, z);
   }

}