package rubik;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import rubik.geometry.ThreeDPoint;

public class Rubik {
   
   static final String VERSION = "1.3";
   static final boolean DEBUG = false;
   
   State state;
   GUI gui;
   ThreeDPoint viewerPosition;
   ThreeDPoint rViewerPosition;
   
   public static void main(String[] args) {
      try {
         UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      } catch (Exception e) {}
      new Rubik().animate();
   }
   
   Rubik() {
      CubeGroup.create();
      Cube.create();
      state = new State();
      gui = new GUI(this, state);
      // start gui on event dispatch thread
      SwingUtilities.invokeLater(gui);
   }
   
   // main thread handles animation
   synchronized void animate() {
      // wait for gui to initialize
      try {
         wait();
      } catch (InterruptedException e) {}

      while (true) {
         // update the state
         synchronized (state) {
            state.update();
         }
         
         // draw the new image
         viewerPosition = state.orientation.mult(state.viewerPosition);
         rViewerPosition = state.rMatrix.transpose().mult(viewerPosition);
         synchronized (gui.image) {
            gui.drawBackground(); // first the background - clouds or stars
            // visit the BSP tree to render the squares
            BSPTreeNode.roots.get(state.rMove.getPlane()).enumerate(new BSPVisitor<Object>() {
               public Object visit(Square s, Object accum) {
                  gui.render(s);
                  return accum;
               }
               public ThreeDPoint viewpoint(Square s) {
                  return state.rotating(s.cube) ? rViewerPosition : viewerPosition;
               }
            }, null);
         }
         gui.repaint();
         // this smoothes out the motion a bit
         try {
            Thread.sleep(10);
         } catch (InterruptedException e) {}
      }
   }
}