package rubik;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.SwingUtilities;

interface MessageEventListener extends EventListener {
   public void eventOccurred(MessageEvent event);
}

class MessageEvent extends EventObject {
   
   private final MessageEvent thisEvent = this;
   String msg;
   
   public MessageEvent(String msg) {
      super(new Object());
      this.msg = msg;
   }

   private static ArrayList<MessageEventListener> listeners = new ArrayList<MessageEventListener>();

   public static void addMessageEventListener(MessageEventListener listener) {
      listeners.add(listener);
   }

   public static void removeMessageEventListener(MessageEventListener listener) {
      listeners.remove(listener);
   }

   public void fire() {
      // invoke on event dispatch thread
      SwingUtilities.invokeLater(new Runnable() {
         public void run() {
            for (MessageEventListener listener : listeners) {
               listener.eventOccurred(thisEvent);
            }
         }
      });
   }
}
